/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportCorePlugin.java,v 1.1 2005/03/30 08:26:53 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report;

import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import org.osgi.framework.BundleContext;

import java.util.*;

/**
 * The main plugin class to be used in the desktop.
 */
public class ReportCorePlugin extends AbstractUIPlugin {
	
	//The shared instance.
	private static ReportCorePlugin plugin;
	//Resource bundle.
	private static  ResourceBundle RESOURCE_BUNDLE; 
	
	public static String getString(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}
	
	/**
	 * The constructor.
	 */
	public ReportCorePlugin()
	{
		super();
		plugin = this;
	}

	public void start( BundleContext context ) throws Exception
	{
	  super.start( context );
	  RESOURCE_BUNDLE = Platform.getResourceBundle(this.getBundle()); 
	}
	/**
	 * Returns the shared instance.
	 */
	public static ReportCorePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String translate(String key) {
		ResourceBundle res = RESOURCE_BUNDLE;
		try {
			if (res==null)
			{
				res = ResourceBundle.getBundle("plugin");
			}
			return res.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return RESOURCE_BUNDLE;
	}
}
