/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Box3D.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 25 juin 2003
 *
 */
package org.eclipse.tptp.platform.report.chart.internal;

/**
 * Support for a 3D Box ... yea, a   c u b e  indeed!
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Box3D
{
  public static final boolean MAX = true;
  public static final boolean MIN = false;
  
  protected double xmin_, ymin_, zmin_;
  protected double xmax_, ymax_, zmax_;
  
  /** Create a box using all field */
  public Box3D( double _xn,double _xx, double _yn,double _yx, double _zn,double _zx )
  {
    xmin_=_xn; xmax_=_xx;
    ymin_=_yn; ymax_=_yx;
    zmin_=_zn; zmax_=_zx; 
  }
  
  /** Create a box using -_dim,+_dim for each coordinates */
  public Box3D( double _dim )
  {
    this( -_dim,+_dim, _dim,+_dim, -_dim,+_dim );
  }

  /** Create a box copying field of given box.
   * @param _B a non null Box3D
   */
  public Box3D( Box3D _B )
  {
    xmin_=_B.xmin_; xmax_=_B.xmax_;
    ymin_=_B.ymin_; ymax_=_B.ymax_;
    zmin_=_B.zmin_; zmax_=_B.zmax_; 
  }

  /** @return minimum coordinate on axis X */
  public double getXMin() { return xmin_; }
  /** @return minimum coordinate on axis Y */
  public double getYMin() { return ymin_; }
  /** @return minimum coordinate on axis Z */
  public double getZMin() { return zmin_; }
  /** @return maximum coordinate on axis X */
  public double getXMax() { return xmax_; }
  /** @return maximum coordinate on axis Y */
  public double getYMax() { return ymax_; }
  /** @return maximum coordinate on axis Z */
  public double getZMax() { return zmax_; }
  
  /** return X min or max, use MIN/MAX */
  public double getX( boolean max ) { return max ? xmax_ : xmin_ ; }
  /** return Y min or max, use MIN/MAX */
  public double getY( boolean max ) { return max ? ymax_ : ymin_ ; }
  /** return Z min or max, use MIN/MAX */
  public double getZ( boolean max ) { return max ? zmax_ : zmin_ ; }
  
}
