/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CategoryScale.java,v 1.5 2008/12/12 22:22:09 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 14 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.chart.internal;

import java.util.List;

import org.eclipse.tptp.platform.report.core.internal.DCategory;

import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.ULocale;


/**
 * Implementation of IScale for Object instance of Category
 * (ie: Integer,Float,Double, ... VFloat,VDouble,... ).
 * This scale can be used also using directly double primitive type.
 *
 * @see IScale.
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class CategoryScale implements IScale
{
  protected double dmin_, dmax_;
  protected double vmin_, vmax_, k_;
  protected boolean reverse_;
  protected UFormat format_;
  protected List categories;
  protected ULocale locale_;
  
  public CategoryScale(List cat)
  {
      categories = cat; 
  }
            
  
  public void setValueRange( Object v1, Object v2 )
  {
      System.out.println("setValueRange");
  }


  public boolean isValid() { return (categories!=null) && (categories.size()>0);  }
  
  public void setTextFormat( UFormat _format )
  {
    format_=_format;
  }

  //private boolean output_once=false;
  
  public String valueText( Object _value )
  {
    if ( _value instanceof DCategory )
        return ((DCategory)_value).getLabel();

    return null;
  }
  
  public void setReversed( boolean b ) { reverse_=b; }
  public boolean isReversed() { return reverse_; }
  

  
  public Object getValueMax( Object _value )
  {
      return (categories!=null ? categories.get(categories.size()-1): null);
  }
  
  public Object getValueMin( Object _value )
  {
      return (categories!=null ? categories.get(0): null);
  }

  public double getScaleMin() { return dmin_; }
  public double getScaleMax() { return dmax_; }

  public double toScale( Object _value )
  {
      if (_value instanceof DCategory)
      {
         int idx = categories.indexOf(_value) +1;
         if( reverse_ )
         {
            return idx * k_ + dmin_ - (k_/2);
         }
         else
         {
             return idx * k_ + dmin_ - (k_/2);
         }
      }
      else
      if (_value instanceof Number)
      {
          int idx = ((Number)_value).intValue();
          if( reverse_ )
             return idx * k_ + dmin_- (k_/2);
          else
              return idx * k_ + dmin_- (k_/2);
      }
      return -1;
  }
  
  
  public Object toValue( double dbl, Object _value )
  {
    int val;
    if( reverse_ )
    {
      val = (int)Math.round(dbl - dmin_ / k_ + (k_/2));
    } else {
      val = (int)Math.round(dbl - dmin_ / k_+ (k_/2));
    }
    
    return categories.get(val);
  }
  
  public void setScaleRange( double dmin, double dmax )
  {
    dmin_ = dmin;
    dmax_ = dmax;
    k_ = (dmax_-dmin_)/categories.size()+1;
  }
  
  public Object stepFirst( Object _step )
  {
      return categories.get(0);
  }
  
  /**
   * @return For given step and value, next 'scaled' value. (>vmax to stop)
   */
  public Object stepNext( Object _step, Object _last )
  {
      if (_last instanceof DCategory)
      {
          int idx = categories.indexOf(_last);
          if (idx==-1)
              return null;
          else
          if (idx<categories.size()-1)
             return categories.get(idx+1);
      }
      return null;
  }

  public double getScaleForBar()
  {
      return dmin_;
  }

  public String toString()
  {
    return super.toString()+"{pixels="+dmin_+".."+dmax_+", range="+vmin_+".."+vmax_+"}";
  }


  public void setLocale(ULocale _locale) {
      locale_ = _locale;
  }

  /** A scale_left > scale_right, taking into account of the isReversed */
 /* public boolean isGT( double scale_left, double scale_right )
  {
    if( reverse_ ) return scale_right > scale_left;
    return scale_left > scale_right ;
  }*/
  /** A scale_left < scale_right, taking into account of the isReversed */
  /*public boolean isLT( double scale_left, double scale_right )
  {
    if( reverse_ ) return scale_right < scale_left;
    return scale_left < scale_right ;
  }*/
  /** A Math.max( scale_left, scale_right ) taking into account of the isReversed */
//   public double max( double scale_left, double scale_right )
//  {
//    if( reverse_ ) return Math.min( scale_left, scale_right );
//    return Math.max( scale_left, scale_right );
//  }
//  /** A min( scale_left, scale_right ) taking into account of the isReversed */
//   public double min( double scale_left, double scale_right )
//  {
//    if( reverse_ ) return Math.max( scale_left, scale_right );
//    return Math.min( scale_left, scale_right );
//  }
//  /** A isGT( scale_left, pixel ) && isLT( pixel, scale_right ) taking into account of the isReversed */
//   public boolean isIN( double scale_left, double pixel, double scale_right )
//  {
//    if( reverse_ ) return (pixel < scale_left ) && ( scale_right < pixel );
//    return (scale_left < pixel ) && ( pixel < scale_right );
//  }
}
