/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ChartDecoderInputStream.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.internal;

import java.io.IOException;
import java.io.InputStream;

/**
 * Chart Input stream decoder.
 * convert any character sequence "HH" to character value 0xHH, where H
 * is hexadecimal digit (0-9a-f).
 * Must be the decoder for ChartEncoderOutputStream.
 * @see ChartAppletViewer.
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class ChartDecoderInputStream extends InputStream
{
  protected InputStream is;
  
  public ChartDecoderInputStream( InputStream is )
  {
    this.is=is;
  }
  
  public int read() throws IOException 
  {
    int b = is.read();
    int hex = 0;    
    if( b>='0' && b<='9' ) {
      hex = b -'0' ;
    } else if( b>='a' && b<='f' ) {
      hex = b -'a' +10;
    }
    else return b;
    //second hexadecimal digit expected:
    b = is.read();
    if( b>='0' && b<='9') {
      hex = 16*hex + b -'0';
    }
    else if ( b>='a' && b<='f' ) {
      hex = 16*hex + b -'a' +10;
    }
    else new IOException("Unexpected char '"+(char)b+"' in encoding sequence.");
    return hex;
  }
    
}
