/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ChartEncoderOutputStream.java,v 1.3 2008/06/12 15:08:01 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.internal;

import java.io.IOException;
import java.io.OutputStream;

/**
 * Encode character of input stream (check E_xxx type) into character sequence "HH" 
 * where HH is the hexadecimal value of character (always two digits).
 * This output stream can be used to encode zip stream before put it in HTML file 
 * (for example), as encoding reduce range 0..255 to 32..126 and take care of html special characters.
 * This encoder must be the reverse encoder of ChartDecoderInputStream.
 * 
 * @see DHtmlGraphicApplet
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class ChartEncoderOutputStream extends OutputStream 
{
  /** encode character in the range 0..31,127..255, '"', '&', '%', '0'..'9','a'..'f' 
      this set is enough to embed outputstream in a html attribute string */ 
  public static final int E_DEFAULT=0;
  /** encode as E_DEFAULT plus '{' '}' '\'' '\\' */
  public static final int E_FORJAVASCRIPT=1;
  /** all input characters are encoded */
  public static final int E_ALL=3;
  
  private OutputStream os_;
  private int encode_;
  private boolean encode_it_[];
  
  public ChartEncoderOutputStream( OutputStream os )
  {
    this( os, E_DEFAULT );
  }
  public ChartEncoderOutputStream( OutputStream os, int encode )
  {
    this.os_=os;
    setEncode( encode );
  }
  
  /** @return encode type, one of E_xxx constants */
  public int getEncode() { return encode_; }
  
  /** Change current encode type, use one of E_xxxx constants */
  public void setEncode( int type )
  {
    switch( type )
    {
    case E_DEFAULT:
    case E_FORJAVASCRIPT:
    case E_ALL:
      encode_ = type;
    break;
    default:
      throw new Error("Unsupported encode type="+type);
    }
    
    if( encode_it_ ==null ) encode_it_ = new boolean[256];
    
    for( int i=0; i<256; i++) encode_it_[i]=false;
    switch( encode_ )
    {
    case E_FORJAVASCRIPT:
      encode_it_['{']=true;
      encode_it_['}']=true;
      encode_it_['\'']=true;
      encode_it_['\\']=true;
      //no break here
    case E_DEFAULT:
      for( int i=0; i<=31; i++ ) encode_it_[i]=true;
      for( int i=127;i<=255; i++) encode_it_[i]=true;
      for( int i='0'; i<='9'; i++) encode_it_[i]=true;
      for( int i='a'; i<='f'; i++) encode_it_[i]=true;
      encode_it_['"']=true;
      encode_it_['&']=true;
      encode_it_['%']=true;      
      break;
    case E_ALL:
      for( int i=0; i<256; i++) encode_it_[i]=true;
    }
  }
  
  public void write(int c) throws IOException 
  {
    int b = (c&0xFF); //24 high bits are ignored
    if( encode_it_[b] ) 
    {
      //use XX sequence, always using two hexadecimal digits.
      int bh = (b&0xF0)>>4;
      int bl = (b&0x0F);      
      if( bh<10 ) os_.write( '0'+bh ); else os_.write('a'+bh-10);
      if( bl<10 ) os_.write( '0'+bl ); else os_.write('a'+bl-10);
    } else {
      os_.write( b );
    }
  }	
  	
}