/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ChartViewerApplet.java,v 1.8 2008/12/12 22:22:09 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.internal;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlGraphicApplet;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.igc.awt.internal.AWTGC;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.render.internal.DRenderRegistry;
import org.eclipse.tptp.platform.report.render.internal.IRender;
import org.eclipse.tptp.platform.report.render.internal.IRenderLocation;
import org.eclipse.tptp.platform.report.render.internal.NullRenderMonitor;
import org.eclipse.tptp.platform.report.sxp.internal.SimpleXmlParser;
import org.eclipse.tptp.platform.report.tools.internal.IVObject;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;


/**
 * JScrib Chart Viewer Applet.
 * 
 * Applet used by HTML Browsers for HTML generated by DHtmlGraphicApplet class.
 * 
 * @see DHtmlGraphicApplet 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class ChartViewerApplet extends Applet implements MouseListener, MouseMotionListener, Runnable
{
  /**
     * 
     */
    private static final long serialVersionUID = 1L;
protected DGraphic graphic_;
  protected IVObject data_;
  protected String   message_; //message to display if graphic is not available
  protected int      loading_; //-1 if not, mod(90) angle for image during loading
  protected boolean  do_tooltip_; //true by default, can be changed by "tooltip" applet's parameter.
  protected int      ttp_background_; //RGBA color of tooltip background
  protected int      ttp_foreground_; //RGBA color of tooltip foreground
  
  public ChartViewerApplet()
  {
    addMouseListener( this );
    addMouseMotionListener( this );
  }

  public String getAppletInfo()
  {
    return "IBM JScrib Chart Viewer Applet 1.0\n"
         + " Copyright IBM Corp. 2003-2004";
  }
  
  public void init()
  {
    message_ = "Initializing...";
  }
  
  //force repaint and drawing of animated "image" during loading...
  private class AnimThread extends Thread
  {
    public void run()
    {
      while( true )
      {
        try{
          Thread.sleep(125);
          if( loading_ < 0 ) break;
          loading_ += 18;
          if( loading_>=180) loading_=0;
        } catch( Throwable t ) {}
        repaint();
      }
    }    
  }
  
  public void start()
  {
    AnimThread anim = new AnimThread();
    anim.start();
    //load graphic in a separate thread as DXmlReader might take time to...
    //and use a thread offer the ability to print "Loading..."
    Thread load = new Thread( this );    
    load.start();    
  }
  
  private InputStream getZipInputStream( String param )
  {
    final ByteArrayInputStream bais = new ByteArrayInputStream( param.getBytes() );
    InputStream is = bais;

    //convert bytes (see DHtmlGraphicApplet class)
    InputStream cis = new ChartDecoderInputStream( bais );    
    ZipInputStream zis = new ZipInputStream( cis );
    
    is=null;
    try {
      ZipEntry zen = null;
      while( (zen=zis.getNextEntry())!=null )
      {
        //jsml zip entry is the only expected one
        if( "jsml".equals( zen.getName() ) ) //$NON-NLS-1$
        {
          is = zis;
          break;
        }
      }
      if( is==null )
      {
        message_ = "Unable to get jsml in zipped parameter";
        repaint();
        return null ;
      }
      return is;
    }
    catch( Exception e )
    {
      e.printStackTrace();
      message_ = "Zip input reading failed, no graphic available.";
      repaint();        
      return null ;
    }
  }
  
  /** Load graphic data from applet's parameter */
  public void run()
  {
    message_ = "Loading graphic ..."; 
    loading_ = 0;
    repaint();
    //some applet parameter
    do_tooltip_ = true;
    String s = getParameter("tooltip");
    if( s!=null ) 
    {
      do_tooltip_ = "true".equals( s );
    }
    ttp_background_ = 0xFFFFAAB0;
    ttp_foreground_ = 0x0000CCFF;
    if( (s=getParameter("tooltip-bgcolor"))!=null) 
    {
       try {
         ttp_background_ = Integer.parseInt( s, 16 );
       } catch( Exception e ) {}
    }
    if( (s=getParameter("tooltip-fgcolor"))!=null) 
    {
       try {
         ttp_foreground_ = Integer.parseInt( s, 16 );
       } catch( Exception e ) {}
    }
    
    String param = getParameter("jsml"); //$NON-NLS-1$
    boolean zipped= false;
    //zipped jsml ?
    if( param ==null )
    {
      param = getParameter("jsml-zip"); //$NON-NLS-1$
      zipped = true;   
    }
    if( param==null )
    {
      graphic_=null;
      message_="Malformed applet tag: missing parameter";
      repaint();
      return ;
    }
    
    InputStream is ;
    if( zipped )
    {       
      is = getZipInputStream( param );
    } else {
      is = new ByteArrayInputStream( param.getBytes() );
    }
    
    SimpleXmlParser p = new SimpleXmlParser();
    DXmlReader reader = new DXmlReader( p );   
    try{        
      IDObject obj[] = reader.read( is );
      
      if( obj!=null ) {
        for( int i=0; i<obj.length; i++ )
        {
          if( obj[i] instanceof DGraphic ) {
            graphic_ = (DGraphic)obj[i];
            message_=null;
            break;
          }
        }
      }
      if( graphic_==null )
      {
        message_="Error reading input, no graphic available";          
      }
    } catch( Throwable e ) { //as DXmlError is not an exception   
      e.printStackTrace();
      message_="Error reading input, no graphic available";
    }      

    loading_=-1;
    repaint();
  }
  
  public void stop()
  {
    graphic_=null;
    message_=null;
    offscreen=null;
    awtgc = null;
  }
   
  private Rect rect = new Rect();
  private Image offscreen;
  private AWTGC awtgc;
  
  private AWTGC getAWTGC()
  {
    Rectangle rr = getBounds();
    if( offscreen==null || offscreen.getWidth(null)!=rr.width || offscreen.getHeight(null)!=rr.height)
    {
      rect.setRect( 0, 0, rr.width, rr.height );
      offscreen = createImage( rr.width, rr.height );
      awtgc = new AWTGC( offscreen.getGraphics() );
    }
    return awtgc;
  }
  
  public void paint(Graphics g)
  {
    Rectangle b = getBounds();
    if( graphic_ == null ) 
    {
      g.setColor( new Color(192,192,192));
      g.fillRect(0,0,b.width,b.height);
      g.setColor( new Color(255,0,0));
      String txt = message_==null ? "No graphic nor message." : message_; 
      FontMetrics fm = g.getFontMetrics();
      int sw = fm.stringWidth( txt ) + (loading_>=0 ? 20 : 0);
      int sh = fm.getHeight() ;
      int tx = (b.width-sw)/2, ty = (b.height-sh)/2;
      g.drawString( txt, tx, ty );
      if( loading_ >=0 )
      {
        tx += sw - 16;
        ty = ty - fm.getAscent() + sh/2 -10;
        g.setColor( new Color(0,0,0) );
        g.fillOval( tx,ty, 20,20 );
        g.setColor( new Color(255,210,0));
        g.fillArc( tx+1,ty+1,18,18, loading_,90);
        g.fillArc( tx+1,ty+1,18,18, loading_+180,90);
      }
      return ;
    }
    IRender render= DRenderRegistry.GetRender( graphic_ );
    render.draw( getAWTGC(), rect, graphic_, 1.0f, null, new NullRenderMonitor(), data_ );
    
    if( do_tooltip_ && ttp_text_!=null )
    {
      paintTooltip();
    }
    Point p = getLocation();
    g.drawImage( offscreen, p.x, p.y, null );//what is ImageObverser?*/
  }
  
  private void paintTooltip()
  {
    Rectangle b = getBounds();
    final int m=3, m2=m+m;
    AWTGC gc = getAWTGC();
    ISize size= gc.textExtent( ttp_text_ );
    int y = ttp_y_ - size.getH()-m2;
    int x = ttp_x_;
    if( x+size.getW()+m2 > b.x+b.width-1 ) x = b.x+b.width-size.getW()-1-m2;
    if( x < b.x ) x=b.x;
    if( y+size.getH()+m2 > b.y+b.height-1) y = b.y-b.height-size.getH()-1-m2;
    if( y < b.y ) y = b.y;
    gc.setClipping( null );
    SolidBrush br = new SolidBrush( ttp_background_ );
    gc.setBrush( br );
    gc.fillRect( x,y, size.getW()+m2,size.getH()+m2);
    br.setRGBA( 0x0000CCFF );
    br.setRGBA( ttp_foreground_ );
    gc.setBrush( br );
    gc.drawText( ttp_text_, x+m, y+m );
    gc.setPen( new LineStylePen( RGBA.BLACK) );
    gc.drawRect( x,y, size.getW()+m2, size.getH()+m2 );
  }
  
  public boolean isDoubleBuffered() { return true; }
  
  public void update(Graphics g) { paint(g); } //mandatory to avoid flickering 

  
  private boolean move_graphic_,moved_graphic_;
  private int defaultProperties_moveGraphicx_;
  private int defaultProperties_moveGraphicy_;
  
  public void mouseClicked(MouseEvent e) {}
  public void mousePressed(MouseEvent e) 
  {
    ttp_text_=null;
    if( graphic_==null ) return ;
    if( !graphic_.canMoves() ) return ;
    move_graphic_=true; moved_graphic_=false;
    defaultProperties_moveGraphicx_ = e.getX();
    defaultProperties_moveGraphicy_ = e.getY();
  }
  
  private String getLinkSpec( IDLink link )
  {
    if( link==null ) return ""; //$NON-NLS-1$
    String spec = prevGraphLink.getTarget();
    if( DLinkUtil.isInternalLink( prevGraphLink) )
    {
      spec = "#"+DLinkUtil.getPath(spec); //$NON-NLS-1$
    }
    return spec;
  }
  
  public void mouseReleased(MouseEvent e) 
  {
    move_graphic_=false;
    if( !moved_graphic_ && prevGraphLink!=null )
    {
      String spec = getLinkSpec( prevGraphLink );
      URL url = null;
      try {
        url = new URL( getDocumentBase(), spec );
        getAppletContext().showDocument( url );
      } catch (MalformedURLException e1) {
        e1.printStackTrace();
      }
    }
  }
  public void mouseEntered(MouseEvent e) {}
  public void mouseExited(MouseEvent e) {}
  
  public void mouseDragged(MouseEvent e) 
  {
    if( move_graphic_ )
    {      
      //copied from SWTViewer.move3DGraphic
      if( graphic_==null ) return ;
		
      float phi   = graphic_.getProperties().get( DGraphic.P_XYZ_PHI, 0.3f );
      float theta = graphic_.getProperties().get( DGraphic.P_XYZ_THETA, 0.2f );
      int dx = e.getX() -defaultProperties_moveGraphicx_;
      int dy = e.getY() -defaultProperties_moveGraphicy_;
      
      phi   += 0.02f*dy;
      theta -= 0.02f*dx;
      graphic_.getProperties().store( DGraphic.P_XYZ_PHI, phi);
      graphic_.getProperties().store( DGraphic.P_XYZ_THETA, theta);
      defaultProperties_moveGraphicx_ = e.getX();
      defaultProperties_moveGraphicy_ = e.getY();    
      //redraw(e.cell);
      repaint();
      moved_graphic_=true; 
      if( prevGraphLink!=null ) setCursor( null ); //reset hand cursor
    }
  }
  
  public IDLink prevGraphLink;
  
  public void mouseMoved(MouseEvent e) 
  {
    // check for a tooltip, and link under mouse (for cursor)
    //if can move graphic, change cursor to reflect that

    //get cell location in contents coordinates, I know there are cell.absoluteXY()
    //but I don't want to allocate a point each time ...
     int cx = 0, cy = 0;
//     for( ITCell c=e.cell; c!=null; c=c.getParent() ) { cx+=c.getX(); cy+=c.getY(); }
     int px =  e.getX()-getLocation().x;
     int py =  e.getY()-getLocation().y;
     IRenderLocation loc = locatePointInGraphic( px,py, graphic_/*, null*/ );
     IDLink link = /*e.viewer.*/extractGraphicLink( loc );
     //if have link-tooltip, no auto tooltip text is build.
     boolean do_ttip = loc!=null ;
     if( link != null )
     {
       String method = DLinkUtil.getMethod( link.getTarget() );
       do_ttip = ( !DLinkUtil.TOOLTIP.equals( method ) );
     }
     IDItem item ;
     
     if( do_ttip && (item=loc.getItem())!=null )
     {
       //ok, now try to build something interesting ...
       if( item instanceof DCurve )
       {
         /*TBD: locate mouse over truncated text "..." (except for Vertical text)
          if( e.tooltip !=null && e.tooltip.indexOf( "...")<0 )
          {
          e.tooltip=null;
          }*/
       }
       else if ( item instanceof DPoint )
       {
         DPoint pt = (DPoint)item;
         IDItem p = pt.getParent();
         DCurve c = p instanceof DCurve ? (DCurve)p:null ;
         p = p.getParent();
         DGraphic g = p instanceof DGraphic ? (DGraphic)p : null;
         
         String title = DefaultChartRenderData.getResourceString(c.getName(), 
                 (DI18N)g.getChildOfClass(DI18N.class));
         
         String t= c!=null && title!=null ? title+": " : ""; //$NON-NLS-1$ //$NON-NLS-2$
         for( IDItem ic=item.getFirstChild(); ic!=null; ic=ic.getNext() )
         {
           if( !(ic instanceof IDCoord)) continue;
           
           IDCoord coord=(IDCoord)ic;
           Object v = coord.getValue(null);
           if( v==null ) continue;
           DAxis  a = coord.getAxis();
           UFormat f=null;
           if( t.length()>0 ) t += "  "; //between coords //$NON-NLS-1$
           if( a!=null ) 
           {
             if( a.getTitle()!=null )
             {
               t+= a.getTitle()+"="; //getName() pas mieux. //$NON-NLS-1$
             }
             try{
               f = (UFormat)a.getProperties().get( DAxis.P_UNIT_FORMAT );
             }
             catch( ClassCastException ex ) {}
           }
           //guess a format
           if( f ==null )
           {
             if ( v instanceof Number )
             {
               f = NumberFormat.getInstance();
             }
             else if ( v instanceof Date )
             {
               //TBD:mmhh might be better to ask a format factory .... ? but user can set P_UNIT_FORMAT property...                             
               f = new SimpleDateFormat("dd MMM yyyy"); //$NON-NLS-1$
             } 
           }
           if( f!=null )
           {
             try{
               t += f.format( v ) ;
             }
             catch( Exception ex ){}
           }
           else
           {
             //TBD: do this or do nothing, because toString() can contains the best as the worst ...                
             t += v.toString();
           }
           if( a!=null && a.getUnit()!=null )
           {
             t+=" "+a.getUnit(); //$NON-NLS-1$
           }
         }//for
         //SWTViewer:e.tooltip = t;
         if( prevGraphLink!=null) t+="  link:"+getLinkSpec( prevGraphLink );
         tooltip( t, e.getX(), e.getY() );
       } else { tooltip(null,0,0); } //remove ttip       
     } else { tooltip(null,0,0); } //remove ttip
     
     if (prevGraphLink!=link)
     {
       if (prevGraphLink!=null)
       {
         //e.type = SWT.MouseExit;
         //e.viewer.defaultMouseEventHandler.invokeDoMethod(prevGraphLink, this, e);
         if(link==null) setCursor(null);
       }
       
       if (link!=null)
       {
        // e.type = SWT.MouseEnter;
        // e.viewer.defaultMouseEventHandler.invokeDoMethod(link, this, e);
         if(prevGraphLink==null) setCursor( new Cursor( Cursor.HAND_CURSOR) );
       }
       prevGraphLink = link;
       return;
     }
     
     prevGraphLink = link;
     if (link!=null){
       //e.viewer.defaultMouseEventHandler.invokeDoMethod(link, this, e);
     }
			
  }
  
  protected String ttp_text_;
  protected int ttp_x_, ttp_y_;
  
//  private Label tooltip;
//  private Frame fttip;
  private void  tooltip( String s, int x, int y )
  {
    getAppletContext().showStatus( s==null ? "" : s );
    ttp_text_=s;
    ttp_x_=x;
    ttp_y_=y;
    repaint();
   /* if( s==null )
    {
      //remove tooltip
      if( fttip!=null) fttip.setVisible(false);
    } else {
      if( tooltip==null )
      {
//? how to remove frame border ? 
//        fttip = new Window( null ); //KO
       fttip = new Frame();
        tooltip = new Label();
        tooltip.setBackground( new Color(255,255,200));
        fttip.add( tooltip );
      }
      tooltip.setText( s );
      fttip.pack();
      for( Container p=getParent(); p!=null; p=p.getParent()) {
        Point l = p.getLocation();
        x += l.x;
        y += l.y;
      }
      fttip.setLocation( x+16, y );
      fttip.setVisible( true );
//TBD: timer to hide automaticaly ? 
    }*/
  }
  
  public IRenderLocation locatePointInGraphic( int px, int py, DGraphic gph /*, ITCell cell*/ )
  {
    if( gph==null ) return null;
    IRender render_ = DRenderRegistry.GetRender( gph );
    IRenderLocation loc = null;
    
    AWTGC awtgc = getAWTGC();
    try
    {
      Rectangle r = getBounds();
      rect.setRect( r.x, r.y, r.width, r.height );
      
      //TCellData celldata = cell instanceof TCellData ? (TCellData)cell : null ;
      
      loc = render_.locate( px, py, awtgc, rect, gph, 1.0f, null, data_ );
    }
    finally
    {
      //no dispose here
    }
    
    return loc;
  }
  
  public static IDLink extractGraphicLink( IRenderLocation loc )
  {
    IDLink link = null;
    if( loc != null ) 
    {
      IDItem item = loc.getItem();
      //link
      if( item instanceof IDLink )
        link = (IDLink)item;
      else
        link = (IDLink)HasParent( item, IDLink.class) ;
    }
    return link;
  }
  
  private static IDItem HasParent(IDItem item, Class wanted)
  {
    if(item == null){
      return null;
    }
    for(IDItem iparent = item.getParent();iparent != null;iparent = iparent.getParent())
    {
      if(wanted.isInstance(iparent))
      {
        return iparent;
      }
    }
    return null;
  }
}
