/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CurveStyle.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 3 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.core.internal.*;
import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;


/**
 * Associate a curve to a style, and more few things useful to render DCurve.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class CurveStyle
{
  /** the curve which style is applied */
  public DCurve curve_;
  /** the chart style created by DefaultChartRender */
  public IGCDStyle style_;
  /** a symbol for curve, used, for legend and point (if XY,with T_POINT), symbol_default ... by default */
  public ISymbol symbol_;

  /** Create a Curve Style */
  public CurveStyle( DCurve _c, float _scale )
  {
    curve_=_c; 
    style_= new IGCDStyle( _c, _scale );
    symbol_ = _c.getSymbol();
    if( symbol_==null ) symbol_=DSymbolRegistry.GetSquare();
  }
  
/*TODO:remove:  public void dispose()
  {
    if(style_!=null) style_.dispose();
  }*/
}
