/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultChartRenderHBars.java,v 1.5 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 3 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.chart.internal;

import java.util.Iterator;
import java.util.Vector;

import org.eclipse.tptp.platform.report.core.internal.*;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.tools.internal.*;


/**
 * Know how to render the fourth layout of T_HBARS graphic type.
 * Currently HBars cannot used other axis that simple axis using Double object as P_CLASS_DATA.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DefaultChartRenderHBars
{
  
  /** Data for one hbar */
  private static class HBarData implements IDisposable
  {
    public String title ; //from curve name but might be truncated
    public ISize title_extend; //one title (from curve name).
    public CurveStyle title_style; //acces to curve/style for title, null if no title, this is a ref!
                                   //I mean do not dispose this!s

    public IDCoord c_begin, c_end ;
    public String begin_text, end_text;
    public IGCDStyle bar_style;
    public DPoint point; //point associated with the bar.
    public ISize  begin_extend, end_extend; 
    
    public void  dispose()
    {
//TODO:remove:      if(bar_style!=null) {bar_style.dispose(); bar_style=null; }
    }
  };
  
  /** data stored into rpd.g */
  private static class RPDHBars implements IDisposable
  {
    DAxis axis1, axis2;
    IGCDStyle axis1_style, axis2_style;
    Insets axis1_am, axis2_am;
    IScale scale1, scale2 ;
    
    int w_max_title =0;
    int w_max_v_begin1 = 0;
    int w_max_v_end1 = 0;
    int w_max_v_begin2 = 0;
    int w_max_v_end2 = 0;
    int num_lines;
    boolean one_value = true; //by default, but this is fixed at first point.
    
    Vector bars1 = new Vector();
    Vector bars2 ;//= one_hbar ? null : new Vector();

    boolean show_title;
    boolean show_v_begin1;
    boolean show_v_end1  ;
    boolean show_v_begin2;
    boolean show_v_end2  ;

    int x_v_begin1, x_v_end1;
//    int x_v_begin2 ;
    int x_v_end2;

    public void dispose()
    {
/*TODO:remove:      
      if( axis1_style!=null) { axis1_style.dispose(); axis1_style=null; }
      if( axis2_style!=null) { axis2_style.dispose(); axis2_style=null; }*/
      if( bars1!=null)
      {
        for( int i=0;i<bars1.size(); ++i )
        {
          ((HBarData)bars1.get(i)).dispose();
        }
        bars1.clear();
      }
      if( bars2!=null)
      {
        for( int i=0;i<bars2.size(); ++i )
        {
          ((HBarData)bars2.get(i)).dispose();
        }
        bars2.clear();
      }
      bars1=null;
      bars2=null;
    }
  }
  
  /**
   * Render T_HBARS graphics
   * <LI>if DGraphic contains one DAxis, this is a one_hbar graphic, if contains two DAxis
   *   this is a two_hbar graphics
   * <LI>if first point contains two coord. for the same axis, all points must have two coord.
   *   defining start and end value of a bar, otherwise this is a classic histogram.
   */
  public static void render( DefaultChartRenderData d, RenderPersistData rpd ) throws DefaultRenderChartLocation
  {
//TODO: need invalidation support ?
// - if min/max changed ?
// - if number of axis changed ?

    RPDHBars p = null;
    if( rpd.g instanceof RPDHBars )
    {
      p = (RPDHBars)rpd.g;
    }
    
    //need rebuild ?
    if( p == null )
    {
      rebuildGraphData( d, rpd );
      p = (RPDHBars)rpd.g;
    }

    boolean one_hbar = (p.axis2==null);
    int h_graph = rpd.ag_rect.h();
    float dh = h_graph /(float)p.num_lines;
    float dh2 = dh/2;
    float y = rpd.ag_rect.top()+dh2;
    
    //bar_space for THIN_BAR property support    
    int bar_space = 0;
    
    if( rpd.graphic.getProperties().get( DGraphic.P_THIN_BAR, false ) )
    {
      bar_space=d.dpiX(3);
      if( 2*bar_space > (int)dh2)
      {
        bar_space=d.dpiX(1);
      }
      else if ( (int)dh > 30 )
      {
        bar_space = Math.max( d.dpiX(3), (int)d.dpiX( (int)(dh-30)/2 ) );
      }
    }  
    
     //but one axis is required
    if( p.axis1==null )
    {
      if( d.draw_ ) d.error( "Missing axis", rpd );
      return ;
    }
    if( !p.scale1.isValid())
    {
      if( d.draw_ ) d.error( "Invalid Min/Max range in axis ("+p.axis1.getName()+")", rpd );
    }
    if( !one_hbar )
    {
      if( !p.scale2.isValid())
      {
        if( d.draw_ ) d.error( "Invalid Min/Max range in axis ("+p.axis2.getName()+")", rpd );
      }
    }
    if( p.num_lines==0 ) return ;//nothing to render.

    
    int x_bar_base1 = (int)p.scale1.getScaleForBar(); 
    int x_bar_base2 = p.scale2==null ? 0 : (int)p.scale2.getScaleForBar();

    /* render axis */
    Rect rg1 = new Rect( (int)p.scale1.getScaleMin(),  (int)rpd.ag_rect.y(), 
                         (int)(p.scale1.getScaleMax()-p.scale1.getScaleMin()), (int)h_graph );
    //locate is done below
    drawHBarAxis( d, p.axis1, p.scale1, p.axis1_am, rg1, p.axis1_style, p.num_lines, y, dh );
    
    Rect rg2 = null;
    if( !one_hbar )
    {
      rg2 = new Rect( (int)p.scale2.getScaleMin(), (int)rpd.ag_rect.y(),
                      (int)(p.scale2.getScaleMax()-p.scale2.getScaleMin()), (int)h_graph );
      rg2.normalize();//can be reversed.
      drawHBarAxis( d, p.axis2, p.scale2, p.axis2_am, rg2, p.axis2_style, p.num_lines, y, dh );
    }
   
    Object v1 = DefaultChartRenderData.getNewInstanceValue( p.axis1 );
    Rect r = new Rect();

    //now time to render bars ...
    int h_bar = (int)(dh-2*bar_space);    
    for( int ibar=0; ibar<p.num_lines; ++ibar )
    {
      HBarData b1 = null;
      HBarData b2 = null;
      try{ b1 = (HBarData)p.bars1.get(ibar); } catch(Exception e){b1=null;}
      try{ b2 = one_hbar? null : (HBarData)p.bars2.get(ibar); } catch(Exception e){b2=null;}
      
      if( b1!=null )
      {
        if( p.show_title && b1.title_style!=null ) // title of bar (from bar1 only)
        {
          r.setRect( rpd.graphic_rect.getX()+d.margin_, (int)(y-dh2), p.w_max_title, (int)(dh));
          d.renderText( b1.title, r, IDAlignment.LEFT, b1.title_style.style_, DLocated.LegendArea, b1.title_style.curve_  );
        }
        if( p.show_v_begin1 ) // text for begin value of bar 1
        {
          r.setRect( p.x_v_begin1, (int)(y-dh2), p.w_max_v_begin1, (int)(dh));
          d.renderText( b1.begin_text, r, IDAlignment.RIGHT, b1.bar_style, DLocated.CurvePointText, b1.point );
        }
        if( p.show_v_end1 ) // text for end value of bar 1
        {
          r.setRect( p.x_v_end1, (int)(y-dh2), p.w_max_v_end1, (int)(dh));
          d.renderText( b1.end_text, r, IDAlignment.RIGHT, b1.bar_style, DLocated.CurvePointText, b1.point );
        }
      }
      if( p.show_v_end2 && b2!=null ) // text for end value of bar 2
      {
        r.setRect( p.x_v_end2, (int)(y-dh2), p.w_max_v_end2, (int)(dh));
        d.renderText( b2.end_text, r, IDAlignment.RIGHT, b2.bar_style, DLocated.CurvePointText, b2.point );
      }
      //note: show_v_begin2 always false : too much text for poor graphic (?)

      
      //bar 1 (always):
      IShape rc = d.gc_.getClipping();
      d.gc_.setClipping( new Rect(rg1.x(), rg1.y(), rg1.w(), rg1.h()) );
      renderHBar( d, b1, p.one_value, y, x_bar_base1, h_bar, bar_space, dh, dh2, p.axis1, p.scale1, r, v1 );
      //bar 2 (maybe) the same...
      if( !one_hbar )
      {
        d.gc_.setClipping( new Rect(rg2.x(), rg2.y(), rg2.w(), rg2.h()) );
        renderHBar( d, b2, p.one_value, y, x_bar_base2, h_bar, bar_space, dh, dh2, p.axis2, p.scale2, r, v1 );
      }
      d.gc_.setClipping( rc );
      
      y += dh;
      if( !d.drawing() && (int)(y-dh2) > d.ly_ ) break ; //optim.
    }
    
    //time to located on X axis:
    d.renderXAxis( false, false, p.axis1, p.scale1, rg1, p.axis1_am, p.axis1_style, IDAlignment.HCENTER );    
    if( !one_hbar ) 
    {
      d.renderXAxis( false, false, p.axis2, p.scale2, rg2, p.axis2_am, p.axis2_style, IDAlignment.HCENTER );
    }
  }
  
  private static HBarData createHBarData( DefaultChartRenderData d_, RPDHBars p, IDCoord b1c1, IDCoord b1c2, DPoint point, Object val1, Object val2, IScale scale, boolean is_bar1 )
  {
    HBarData bar = new HBarData();
    bar.bar_style   = new IGCDStyle( point, d_.scale_ );
    bar.point       = point;

    if( p.one_value )
    {
        val1 = b1c1.getValue( val1 );
        
        bar.c_end = b1c1;
        bar.end_text = scale.valueText( val1 );

        d_.gc_.setFont( bar.bar_style.getFont() );
        bar.end_extend = DrawUtilIGC.textExtent( d_.gc_, bar.end_text, IDAlignment.LEFT );
        
        int w_vx = bar.end_extend.getW();
        if( is_bar1 )
        {
          if( w_vx > p.w_max_v_end1 ) p.w_max_v_end1=w_vx;
        } else {
          if( w_vx > p.w_max_v_end2 ) p.w_max_v_end2=w_vx;
        }        
      } 
      else //two values
      {
        val1 = b1c1.getValue( val1 );
        val2 = b1c2.getValue( val2 );
                
        //sort coordinate ... if comparable ...
        if( val1 instanceof Comparable )
        {
          if( ((Comparable)val1).compareTo( val2=b1c2.getValue(val2) ) > 0)
          {
            IDCoord c = b1c1; b1c1=b1c2; b1c2=c;
            Object o = val1; val1=val2; val2=o;
          }
        }
                
        bar.c_begin = b1c1;
        bar.c_end   = b1c2;
        bar.begin_text  = scale.valueText( val1 );
        bar.end_text    = scale.valueText( val2 );

        d_.gc_.setFont( bar.bar_style.getFont() );
        bar.begin_extend = DrawUtilIGC.textExtent( d_.gc_, bar.begin_text, IDAlignment.LEFT );
        bar.end_extend   = DrawUtilIGC.textExtent( d_.gc_, bar.end_text, IDAlignment.LEFT );

        int w_vn = bar.begin_extend.getW();
        int w_vx = bar.end_extend.getW();
        //fix value  min/max and text extends ... depend on bar.
        if( is_bar1 )
        {
          if( w_vn > p.w_max_v_begin1 ) p.w_max_v_begin1=w_vn;
          if( w_vx > p.w_max_v_end1   ) p.w_max_v_end1  =w_vx;
        } else {
          if( w_vn > p.w_max_v_begin2 ) p.w_max_v_begin2=w_vn;
          if( w_vx > p.w_max_v_end2   ) p.w_max_v_end2  =w_vx;
        }
      }
      return bar;
  }

  private static void drawHBarAxis( DefaultChartRenderData d, DAxis axis, IScale scale, Insets insets, Rect r, IGCDStyle sty_axis, int num_lines, float y, float dh  )
    throws DefaultRenderChartLocation
  {
    d.gc_.setFont( sty_axis.getFont() );    
    if( d.drawing() )
    {
      //horizontal lines here:
      LineStylePen pen = new LineStylePen( sty_axis.getFore(), LineStylePen.DOT );
      IPen old = d.gc_.setPen( pen );
      float ly=y;
      for( int i=0; i<num_lines; ++i )
      {
        d.gc_.drawLine( r.left(), (int)ly, r.right(), (int)ly );
        ly += dh;
      }        
      d.gc_.setPen( old );

      d.renderXAxis( false, true, axis, scale, r, insets, sty_axis, IDAlignment.HCENTER );

      pen.setRGBA( RGBA.BLACK );
      pen.setLineStyle( LineStylePen.SOLID );
      d.gc_.setPen( pen );
      d.gc_.drawRect( r.x(), r.y(), r.w(), r.h() );
    }
  }
  
//tant de parametres ... deplacer tout ca  dans une autres classe serait mieux ...  
  private static void renderHBar( DefaultChartRenderData d, HBarData data, boolean one_value, float y, int x_bar_base, int h_bar, int bar_space, float dh, float dh2, DAxis axis, IScale scale, Rect r, Object val )
    throws DefaultRenderChartLocation
  {
    int xvn = one_value ? x_bar_base : (int)scale.toScale( data.c_begin.getValue(val) );
    int xvx = (int)scale.toScale( data.c_end.getValue(val) );
    //required for bar_space==0;
    float y1 = (y-dh2+bar_space);
    float y2 = (y1+dh-bar_space);
     r.setRect( xvn, (int)y1, xvx-xvn, (int)(y2-(int)y1) );
    if(  d.drawing() )
    {
      //black rectangle around whole bar.
      d.gc_.setBrush( new SolidBrush( data.bar_style.getBack()) );
      d.gc_.fillRect( r.left(), r.y(), Math.abs(r.w()), r.h() );
      d.gc_.setPen( new LineStylePen( RGBA.BLACK ) ); //?remove fix color for accessibility purpose.
      d.gc_.drawRect( r.left(), r.y(), Math.abs(r.w()), r.h() );
    } 
    else  //locate:
    {
      if( r.contains( d.lx_, d.ly_ ))
      {
        throw new DefaultRenderChartLocation(DLocated.LegendArea, data.point, r );      
      }
    }
  }
  
  private static final int margin = 5;
  
  private static void rebuildGraphData( DefaultChartRenderData d, RenderPersistData rpd )
  {    
    RPDHBars  p = new RPDHBars();
    rpd.g = p;
      
      for( IDItem item = rpd.graphic.getFirstChild(); item!=null; item=item.getNext())
      {
        if( !(item instanceof DAxis) ) continue;
        if( p.axis1==null )
        {
           p.axis1 = (DAxis)item;
        }
        else if( p.axis2 == null )
        {
          p.axis2 = (DAxis)item;
          //two axis is enough to process...
          break;
        }
      }
      //but one axis is required
      if( p.axis1==null )
      {
        if( d.draw_ ) d.error( "Missing axis", rpd );
        return ;
      }
    
      //now fix kind of graphic
      boolean one_hbar = (p.axis2==null);

      //Guess if it's a simple bar (one Coord) or a double value bar (2 coords on same axis).
      for( int icrv=0; icrv<rpd.curve_styles.length; ++icrv )
      {
        CurveStyle cs = rpd.curve_styles[icrv];
        DCurve curve = cs.curve_;
        //b1 is bar 1, b2 is bar 2, c1 for coord 1 c2 for coord 2.  
        guess_two_values_by_bar:    
        for( IDItem i = curve.getFirstChild(); i!=null; i=i.getNext() )
        {
          if( !(i instanceof DPoint) ) continue;  

          DPoint point = (DPoint)i;
          //one or two value for axis 1?
          int num_coord_axis1=0;
          for( IDItem ic = point.getFirstChild(); ic!=null; ic=ic.getNext())
          {
            if(!(ic instanceof DCoord)) continue;
            DCoord coord = (DCoord)ic;      
            if( coord.getAxis() == p.axis1 )
            {
             num_coord_axis1++;
              //ok we know!
              if( num_coord_axis1==2)
              {
                 p.one_value =false; //two values by bar.
                 break guess_two_values_by_bar;
              } 
            }
          }
          //first valid point fix the graph type.
          if( num_coord_axis1 ==1 ) break;
        }
      } //for
    
      if( !one_hbar ) p.bars2 = new Vector();
      
      Object val1 = DefaultChartRenderData.getNewInstanceValue( p.axis1 );
      Object val2 = DefaultChartRenderData.getNewInstanceValue( p.axis2 );

      //create scale to access text formatting, pixel bounds and values will be set latter
      p.scale1 = DefaultChartRenderData.getScale( p.axis1, 0,0,null,null );  
      p.scale2 = DefaultChartRenderData.getScale( p.axis2, 0,0,null,null );  
    
      //Now get datas from other points
      for( int icrv=0; icrv<rpd.curve_styles.length; ++icrv )
      {
        CurveStyle cs = rpd.curve_styles[icrv];
        DCurve curve = cs.curve_;
        for( IDItem i = curve.getFirstChild(); i!=null; i=i.getNext() )
        {
          if( !(i instanceof DPoint) ) continue;

          //b1 is bar 1, b2 is bar 2, c1 for coord 1 c2 for coord 2.
          DCoord b1c1, b1c2, b2c1, b2c2; 
          b1c1=null; b1c2=null; b2c1=null; b2c2=null;       
          DPoint point1=null, point2=null;
          
          DPoint point = (DPoint)i;
          //check coords: the point can define two bars or only one.
          for( IDItem ic=point.getFirstChild(); ic!=null; ic=ic.getNext())
          {
            if(!(ic instanceof DCoord)) continue;
            DCoord coord = (DCoord)ic;          
            DAxis axis = coord.getAxis();
          
            if( axis==p.axis1) //coord for bar 1
            {
              point1=point;
              if( b1c1==null )
              {
                b1c1 = coord;
              }
              else if ( !p.one_value ) 
              {
                if( b1c2 == null )
                {
                  b1c2 = coord;
                }
              }
              //two many coord for axis one, but don't be in trouble
            }
            else if ( axis==p.axis2 && !one_hbar ) 
            {
              point2=point;
              if( b2c1==null )
              {
                b2c1 = coord;
              }
              else if ( !p.one_value ) 
              {
                if( b2c2 == null )
                 {
                  b2c2 = coord;
                }
              }
            }
          } //for coords
        
          HBarData b1 = null;
          HBarData b2 = null;
        
          //coords for bar1 ?
          if( b1c1!=null && ( p.one_value || !p.one_value&&(b1c2!=null)) )
          {      
             b1 = createHBarData( d, p, b1c1, b1c2, point1, val1, val2, p.scale1, true );
          }
          //coords for bar2 ?
          if( b2c1!=null && ( p.one_value || !p.one_value&&(b2c2!=null)) )
          {
             b2 = createHBarData( d, p, b2c1, b2c2, point2, val1, val2, p.scale2, false );
          }        

          if( b1==null && b2==null ) continue; //next point
        
          //only bar1 contains title.
          if( b1!=null )
          {
            b1.title_style = cs ;
            d.gc_.setFont( cs.style_.getFont() );
            
            b1.title = DefaultChartRenderData.getResourceString(curve.getName(), 
                    (DI18N)rpd.graphic.getChildOfClass(DI18N.class));
            
            b1.title_extend = DrawUtilIGC.textExtent( d.gc_, b1.title, IDAlignment.LEFT );
            int w_title = b1.title_extend.getW();
            if( w_title > p.w_max_title ) p.w_max_title = w_title;
          }
        
          //if both defined, force them to be in same line.
          if( b1!=null && b2!=null )
          {
            while( p.bars1.size() < p.bars2.size() ) p.bars1.add( null ); //null means empty
            while( p.bars2.size() < p.bars1.size() ) p.bars2.add( null ); 
          }

          if( b1!=null ) p.bars1.add( b1 );
          if( !one_hbar && b2!=null ) p.bars2.add( b2 );
        
        }
      }//for
   
      p.num_lines = Math.max( p.bars1.size(), one_hbar ? 0 : p.bars2.size() );       
      if( p.num_lines==0 ) return ;//nothing to render.
    
      boolean truncate_title    = false;
      boolean truncate_v_begin1 = false;
      boolean truncate_v_end1   = false;
      boolean truncate_v_begin2 = false;
      boolean truncate_v_end2   = false;

      int wg = rpd.ag_rect.w();
      {
        //limit values to the quarter /eight of space:
        int div = one_hbar ? 4 : 8 ;
        if( p.w_max_v_begin1 > wg/div ) { p.w_max_v_begin1 = wg/div; truncate_v_begin1=true; } 
        if( p.w_max_v_end1   > wg/div ) { p.w_max_v_end1   = wg/div; truncate_v_end1  =true; } 
        int wc = p.w_max_v_begin1 + p.w_max_v_end1;
        if( !one_hbar )
        {
          if( p.w_max_v_begin2 > wg/div ) { p.w_max_v_begin2 = wg/div; truncate_v_begin2=true; } 
          if( p.w_max_v_end2   > wg/div ) { p.w_max_v_end2   = wg/div; truncate_v_end2  =true; } 
          wc += p.w_max_v_begin2 + p.w_max_v_end2;
        }
        int w = p.w_max_title + wc ;
        //limit to the half of space...
        if( w > wg/2 )      
        {
          p.w_max_title = wg/2 - wc;
          truncate_title = true;
        }
      }

      DPropertyStore p_axis1 = p.axis1.getProperties();
      //use P_MIN/MAX prior ... or try to sort values (need Comparable)
      Object vmin1 = p_axis1.get( DAxis.P_MIN );
      Object vmax1 = p_axis1.get( DAxis.P_MAX );   
      if( vmin1==null || vmax1 == null )
      {
        MinMax mm = computeMinMax( p, true );
        if( mm!=null )
        {
          vmin1 = mm.getVMin();
          vmax1 = mm.getVMax();
        }
      }
      p.scale1.setValueRange( vmin1, vmax1 );  
      
      DPropertyStore p_axis2 = null;
      if( !one_hbar )
      {
        p_axis2 = p.axis2.getProperties();
        Object vmin2 = p_axis2.get( DAxis.P_MIN );
        Object vmax2 = p_axis2.get( DAxis.P_MAX );      
        if( vmin2==null || vmax2 == null )
        {
          MinMax mm = computeMinMax( p, false );
          if( mm!=null )
          {
            vmin2 = mm.getVMin();
            vmax2 = mm.getVMax();
          }
        }
        p.scale2.setValueRange( vmin2, vmax2 );
      }
      
//TBD: take care of axis amounts ... to compute xl_graph/xr_graph and mid_graph, (and...)          
      p.show_title   = p.w_max_title   > d.dpiX(20) ;//+ a property ?
      p.show_v_begin1= one_hbar && !p.one_value && p.w_max_v_begin1 > d.dpiX(15); //+ a property ?
      p.show_v_end1  =  (p.one_value||one_hbar) && (p.w_max_v_end1   > d.dpiX(15)); //+ a property ?
      p.show_v_begin2= false; //&&!one_value && w_max_v_begin2 > 15; //+ a property ?
      p.show_v_end2  = !one_hbar && p.one_value && (p.w_max_v_end2   > d.dpiX(15)); //+ a property ?

      p.x_v_begin1 = p.show_title ? rpd.ag_rect.x()+p.w_max_title + margin : 0; //on the right of title
      p.x_v_end1   = p.show_v_end1 ? rpd.ag_rect.right()-p.w_max_v_end1 : rpd.ag_rect.right(); //on the right of graph
//    int x_v_begin2 = show_title ? _rg.x()+w_max_title + margin : 0; // never rendered
      p.x_v_end2   = p.show_v_end2 ? rpd.ag_rect.x()+p.w_max_title + margin : 0; //in place of begin1 (both never rendered at same time)

      int xl_graph1  = -1;
      int xr_graph1  = p.show_v_end1 ? p.x_v_end1 -margin : rpd.ag_rect.right(); //always
      int xl_graph2  = -1; 
      int xr_graph2  = -1;
    
      if( one_hbar )
      {
        if( p.show_v_begin1 )
        {
          xl_graph1 = p.x_v_begin1+p.w_max_v_begin1+margin;
        }
        else if (p.show_title )
        {
          xl_graph1 = rpd.ag_rect.x()+p.w_max_title+margin;
        }
        else
        {
          xl_graph1 = rpd.ag_rect.left();
        }
      }
      else //two hbar
      {
        if( p.show_v_end2 )
        {
          xl_graph2 = p.x_v_end2+p.w_max_v_end2+margin; 
        }
        else if (p.show_title )
        {
          xl_graph2 = rpd.ag_rect.x()+p.w_max_title+margin;
        }
        else
        {
          xl_graph2 = rpd.ag_rect.left();
        }
//use amounts here... too but... amounts not correct because pixel bounds unknown       
        int mid_graph = (xr_graph1+xl_graph2)/2;
        xl_graph1 = mid_graph+margin/2;
        xr_graph2 = xl_graph1-margin;
      }

      //now inner graph rectangle is (include both graphic)
      rpd.ag_rect.setLeft( one_hbar ? xl_graph1 : xl_graph2 );
      rpd.ag_rect.setRight( xr_graph1 );
      
      //now set scales bounds
      p.scale1.setScaleRange( xl_graph1, xr_graph1 );
      if( !one_hbar )
      {
        p.scale2.setReversed( true );
        p.scale2.setScaleRange( xr_graph2, xl_graph2 );       
      }
      
      //get axis amounts, get max_h
      p.axis1_am = d.computeXAxisAmounts( p.axis1, p.scale1, rpd.ag_rect, IDAlignment.BOTTOM|IDAlignment.HCENTER, null);
      int max_h = p.axis1_am.getB() ;
      if( !one_hbar )
      {
        p.axis2_am = d.computeXAxisAmounts( p.axis2, p.scale2, rpd.ag_rect, IDAlignment.BOTTOM|IDAlignment.HCENTER, null);
        max_h = Math.max( max_h, p.axis2_am.getB() ) ;
      }
      
      rpd.ag_rect.setHeight( rpd.ag_rect.h()-max_h );

      if( p.axis1_style == null )
      {
        p.axis1_style = new IGCDStyle( p.axis1, d.scale_ );
        p.axis2_style = one_hbar ? null : new IGCDStyle( p.axis2, d.scale_ );
      }

      //ok scale are placed, have styles, now time to truncat text...
      if( truncate_title && p.show_title && (p.bars1!=null) )
      {
        //title are stored in bar1
        for( int i=0; i<p.bars1.size(); ++i )
        {
          HBarData b = (HBarData)p.bars1.get(i);
          d.gc_.setFont( b.title_style.style_.getFont() );
          b.title = DrawUtilIGC.truncateText( d.gc_, b.title, p.w_max_title, 0, IDAlignment.LEFT );
        }
      }
      boolean do_begin = truncate_v_begin1 && p.show_v_begin1;
      boolean do_end   = truncate_v_end1   && p.show_v_end1;
      if( do_begin || do_end && p.bars1!=null )
      {
        for( int i=0; i<p.bars1.size(); ++i )
        {
          HBarData b = (HBarData)p.bars1.get(i);
          d.gc_.setFont( b.bar_style.getFont() );
          if( do_begin )
          {
            b.begin_text = DrawUtilIGC.truncateText( d.gc_, b.begin_text, p.w_max_v_begin1, 0, IDAlignment.RIGHT );
          }
          if( do_end )
          {
            b.end_text = DrawUtilIGC.truncateText( d.gc_, b.end_text, p.w_max_v_end1, 0, IDAlignment.RIGHT );
          }
        }
      }
      do_begin = truncate_v_begin2 && p.show_v_begin2;
      do_end   = truncate_v_end2   && p.show_v_end2;
      if( do_begin || do_end && p.bars2!=null )
      {
        for( int i=0; i<p.bars2.size(); ++i )
        {
          HBarData b = (HBarData)p.bars2.get(i);
          d.gc_.setFont( b.bar_style.getFont() );
          if( do_begin )
          {
            b.begin_text = DrawUtilIGC.truncateText( d.gc_, b.begin_text, p.w_max_v_begin2, 0, IDAlignment.RIGHT );
          }
          if( do_end )
          {
            b.end_text = DrawUtilIGC.truncateText( d.gc_, b.end_text, p.w_max_v_end2, 0, IDAlignment.RIGHT );
          }
        }
      }
  }
  
  // return min/max of values on an axis ... need Comparable data class
  // vmin/vmax are suitable for this data class..
  private static MinMax computeMinMax( RPDHBars p, boolean for_axis1 )
  {
    boolean one_value = p.one_value ;
    Vector bars = for_axis1 ? p.bars1 : p.bars2 ;
    DAxis  axis = for_axis1 ? p.axis1 : p.axis2 ;
    
    if( axis==null || bars==null || bars.size()==0 ) return null;

    MinMax mm = new MinMax( axis );
      
    HBarData bd= null;

    if( one_value ) //two values
    {      
      for( Iterator i = bars.iterator(); i.hasNext(); )
      {
        bd = (HBarData)i.next();
        mm.update( bd.c_end );
      }
    } else {
      for( Iterator i = bars.iterator(); i.hasNext(); )
      {
        bd = (HBarData)i.next();
        mm.update( bd.c_begin );
        mm.update( bd.c_end   );
      }
    }
    return mm;
  }
    
}

