/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultChartRenderMeter.java,v 1.4 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.core.internal.*;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;


/**
 * Default render for Meter Chart.
 * 
 * @author ademuyser
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DefaultChartRenderMeter 
{
  /* Render a Meter graphic.
   * Currently doesn't have any Persist Data ... might be done on needed.
   */
  public static void render( DefaultChartRenderData d, RenderPersistData rpd )
     throws DefaultRenderChartLocation
  {
    DGraphic gph = rpd.graphic;
    
    DAxis axis = null;
    for( IDItem item=gph.getFirstChild(); item!=null; item=item.getNext() )
    {
      if( item instanceof DAxis )
      {
        axis=(DAxis)item;
        break;
      }
    }
    if( axis==null )
    {
      d.error( "Error: missing axis", rpd );
      return ;
    }
    
    Object vmax = axis.getProperties().get( DAxis.P_MAX );
    Object vmin = axis.getProperties().get( DAxis.P_MIN );
    if( vmax==null ) vmax = axis.getProperties().get( DAxis.P_MAX_HINT );
    if( vmin==null ) vmin = axis.getProperties().get( DAxis.P_MIN_HINT );
    
    if( vmin==null || vmax==null )
    {
      //can't update alone because meter use only one value (=needle).
      //except if axis is numbered ... I choose 0..100 by default
      if( axis.useNumbers() )
      {
        vmin = new Double(0.0);
        vmax = new Double(100);
      } else {
        d.error("Error: axis min/max must be set", rpd );
        return ;
      }
    }
    
    IScale scale = DefaultChartRenderData.getScale( axis, Radian._PI,0, vmin,vmax );
    if( !scale.isValid() )
    {
      d.error("Error: invalid scale",rpd);
      return ;
    }
    
    int rg_w = rpd.ag_rect.w();
    int rg_h = rpd.ag_rect.h();
    int center_x = rpd.ag_rect.centerX();
    int center_y = rpd.ag_rect.centerY();
    int out_radius = Math.min( rg_w, rg_h )/2;
    
    if( d.drawing() )
    {      
      IPen old = d.gc_.setPen( new LineStylePen( RGBA.BLACK, LineStylePen.SOLID, 3 ) );
      d.gc_.drawCircle( center_x, center_y, out_radius );
      d.gc_.setPen( old );
    }
    //little margin
    out_radius -= d.dpiX(3);

    double al = 0.0; //angle of point to locate...
    double ar = 0.0; //dist to center of point to locate...
    if( d.locating())
    {
      int dx = d.lx_-center_x, dy = d.ly_-center_y;
      al = Radian.normalize( Math.atan2( -dy, dx ) );
      ar = Math.sqrt( dx*dx+dy*dy );
    }
    
    //as region are rendered(located) first, we must store temporaly which region is
    //under point to locate because a needle can stand between point and region...
    DefaultRenderChartLocation loc_region = null;    

    
    /* Now I need to know how STEP_UNIT take place .. */
    IGCDStyle style = new IGCDStyle( axis, d.scale_ );
    
          
    d.gc_.setFont( style.getFont() );
    // <0 means no unit_radius
    int unit_radius = estimateUnitRadius( d, axis, scale, center_x,center_y, out_radius );
    
    //if unit's text take more than XX% of radius: do not print them.
    if( unit_radius < (int)(0.65*out_radius) )
    {
      unit_radius = -1;
    }
    
    //I can set radius of  meter.  
    int ray=out_radius;
    if( unit_radius > 0 )
    {
      ray = unit_radius - d.dpiX(3); //little margin
    }
    int diam = 2*ray;
      
      
    /*
     * render regions (remember curve 0 is the needle)
     */
    Object v_curr=null;
    double arad_last=Radian._PI;
    SolidBrush brush = new SolidBrush(RGBA.WHITE);
    for( int icrv=1; icrv<rpd.curve_styles.length; ++icrv )
    {
      CurveStyle ccurve = rpd.curve_styles[icrv];    
      DPoint point=null;
      //curves may contains several sectors
      for( IDItem item=ccurve.curve_.getFirstChild(); item!=null; item=item.getNext() )
      {
        if( !(item instanceof DPoint ) ) continue;
        point =(DPoint)item;
        IDItem itc=point.getFirstChild();
        if( itc instanceof IDCoord )
        {
          IDCoord c = (IDCoord)itc;
          if( c.getAxis()==axis)
          {
            v_curr = c.getValue(v_curr);
            break;
          }
        }
      }//for
      if( v_curr!=null )
      {
        double a = scale.toScale( v_curr );  
        if( d.drawing() )
        {
          brush.setRGBA( IGCDStyle.GetBackColor( ccurve.curve_) );
          d.gc_.setBrush( brush );
          
          double da = arad_last-a;      
          d.gc_.fillArc( center_x, center_y, 0.0, ray,ray, a, da );
        }
        else
        {
          if( ar<=ray && arad_last >= al && al >= a )
          {
            loc_region = new DefaultRenderChartLocation( DLocated.CurveSector, point, null );
          }
        }
        arad_last=a;          
      }
    }//for regions
      
      
    /*
     * STEP_LINE
     */
    Object step = axis.getProperties().get( DAxis.P_STEP_LINE );
    if ( d.drawing() && (step !=null ) )
    {
      IPen old = d.gc_.setPen( new LineStylePen( d.getLineColor( axis ) ) );  
      
      int lsize = Math.min( 10, ray/4 );
      //min size to render lines...
      if( lsize > 2 )
      {
        //little lines
        int r0 =ray-d.dpiX(lsize);
        for( Object vs = scale.stepFirst(step); vs!=null;  vs=scale.stepNext(step,vs) )
        {
          // int xray=(int)scale.toScale( vs );      
          // int xray2 = xray*2;
          // d_.gc_.drawOval( center_x-xray, center_y-xray, xray2, xray2 );
          double a = -Math.PI+scale.toScale( vs ); 
          double cs = Math.cos(a);
          double sn = Math.sin(a);
          int x0 = center_x+(int)(r0 *cs), y0 = center_y +(int)(r0*sn);
          int x1 = center_x+(int)(ray*cs), y1 = center_y +(int)(ray*sn);
          d.gc_.drawLine( x0,y0, x1,y1 );
        }
      }
      d.gc_.setPen( old );
    }

    /*
     * STEP_UNIT
     */
    if( unit_radius > 0 )
    {
      step = axis.getProperties().get( DAxis.P_STEP_UNIT );
      if ( step !=null )
      {
        for( Object vs = scale.stepFirst(step); vs!=null;  vs=scale.stepNext(step,vs) )
        {
          double a = scale.toScale( vs );    
          String txt = scale.valueText( vs );           
          d.renderSectorText( a, unit_radius,rpd.ag_rect, txt, axis, style, DLocated.InAxisXUnit );
        }
      }
    }
      
    //need to know needle axis radius fo shift.
    //it's limited between 3..10 pixels (with the respect of dpi)
    int needle_axis_radius = d.dpiX(Math.min(Math.max(diam/40,3),10));
    
    //vert. margin for axis title and main needle value.
    int v_margin = d.dpiY( Math.min(5, Math.max( out_radius/20, 1)));
    
    /*
     * Axis title below meter.
     */
    int shift_axis_title= center_y+ v_margin+needle_axis_radius;
    if( axis.getTitle()!=null )
    {
      String txt = axis.getTitle();
      
      d.gc_.setFont( style.getFont() );
      ISize size = d.gc_.textExtent( txt );
      Rect rect = new Rect( 0,0,size.getW(), size.getH() );
      shift_axis_title += size.getH()/2;
      rect.moveCenter(center_x, shift_axis_title );
      
      boolean place_title=true;
      //place for title ?
      if( rect.bottom() > center_y+out_radius )
      {
        //bottom of rect is outside circle.
        place_title=false;
      }
      if( place_title )
      {
        //check if rect's bottom/left (right) corner are inside circle.
        //easy because title is centered on center_x.
        int dx = rect.w()/2; //centered;
        int dy = rect.bottom()-center_y;
        double r = Math.sqrt( dx*dx + dy*dy );
        if( r >= out_radius )
        {
          //no place.
          place_title=false;
        }
      }
      
      if( place_title )
      {
        shift_axis_title += rect.h();
        
        d.renderText( txt, rect, IDAlignment.CENTER, style, DLocated.InAxisXTitle, axis );
      }
    }
      
      
    /*
     * Needle.
     */
    {
      CurveStyle cneedle = rpd.curve_styles[0];    
      boolean main_needle=true;
      
      int needle_margin = Math.min( 5, Math.max(ray/20,2) );
      int needle_radius = ray-needle_margin ;
      LineStylePen pen = new LineStylePen(RGBA.BLACK);
      for( IDItem itp=cneedle.curve_.getFirstChild(); itp!=null; itp=itp.getNext() )
      {
        if( !(itp instanceof DPoint )) continue;
        
        Object value=null;
        DPoint point = (DPoint)itp;
        for (IDItem pc = point.getFirstChild(); pc!=null; pc=pc.getNext())
        {
          if( pc instanceof IDCoord )
          {
             IDCoord c = (IDCoord)pc;
             if( c.getAxis()==axis)
             {
                value=c.getValue(value);
             }
          }
        }
        
        //have needle ?
        if( value!=null )
        {
          double a = scale.toScale( value );
          
          int x = (int)(center_x+ needle_radius*Math.cos(a));
          int y = (int)(center_y- needle_radius*Math.sin(a));
          IGCDStyle sty = new IGCDStyle( point, d.scale_);
          
          if(d.drawing())
          {
            pen.setRGBA( sty.getFore() );
            pen.setLineWidth( 3 );
            IPen old = d.gc_.setPen( pen );
            d.gc_.drawLine( center_x, center_y, x,y );
            d.gc_.setPen( old );
          }
          else //locate needle line
          {
            double da=Math.abs(al-a);
            //be precise please ... 1% of PI !
            if( da<0.01*Math.PI && ar<=ray )
            {
              throw new DefaultRenderChartLocation( DLocated.CurvePoint, point, null );
            }
          }
          
          //Value of main needle is displayed above axis title
          if( main_needle )
          {
            String txt = scale.valueText( value );
            d.gc_.setFont( sty.getFont() );
            ISize size = d.gc_.textExtent( txt );
            Rect rect = new Rect(0,0,Math.max( size.getW(), out_radius/*diam/2*/), size.getH() );
            rect.moveCenter( center_x, shift_axis_title+v_margin );//d.margin_ );
            //               rect.moveCenter( center_x, center_y+out_radius/2-ext.y/2);
            
            boolean render_value = true;
            if( rect.bottom() >= center_y+out_radius)
            {
              //no place
              render_value=false;
            }
            else 
            {
              //check for rect's width
              int dx = rect.w()/2;
              int dy = rect.bottom()-center_y;
              double r = Math.sqrt( dx*dx +dy*dy );
              if( r >= out_radius )
              {
                //no, nbut I can reduce rect's width to not render outside circle.
                int w = 2*(int)Math.sqrt( Math.abs(out_radius*out_radius - dy*dy ));
                //now the limit is text to display ...
                if( w <= size.getW() )
                {
                  render_value=false;
                }
                else
                {
                  //re-bounds text rect.
                  rect.setWidth( w );
                  rect.moveCenter( center_x, shift_axis_title+v_margin );
                }
              }
            }
            
            if( render_value )
            {
              if( d.drawing())
              {
                pen.setRGBA( sty.getFore() );
                pen.setLineWidth( 0 );
                d.gc_.setPen( pen );
                d.gc_.setBrush( new SolidBrush( sty.getBack() ));
                d.gc_.fillRect( rect.x(), rect.y(), rect.w(), rect.h() );
                d.gc_.drawRect( rect.x(), rect.y(), rect.w(), rect.h() );
                d.gc_.setBrush( new SolidBrush( sty.getFore() ) );
                d.renderText( txt, rect, IDAlignment.CENTER, sty, DLocated.CurvePoint, point );
              }
              else //locating
              {
                if( rect.contains(d.lx_,d.ly_))
                {
                  throw new DefaultRenderChartLocation( DLocated.CurvePoint, point, rect );
                }
              }
            }
          }
        }//have needle
        
        main_needle=false;
      }
    }
      
    /*
     * Needle axis (just for fun), style is from axis's style
     */
    if( d.drawing() )
    {
      d.gc_.setBrush( new SolidBrush( rpd.g_style.getBack() ) );
      d.gc_.setPen( new LineStylePen( style.getFore() ) );
      int ry= needle_axis_radius;
      int dm=ry+ry;
      d.gc_.fillCircle( center_x, center_y, ry );
      d.gc_.drawCircle( center_x, center_y, ry );
      
      ry = Math.min( d.dpiX(2), needle_axis_radius/2 );  
      if( ry==1 )
      {
        d.gc_.drawPoint( center_x, center_y );
      } else {
        dm=ry+ry;
        d.gc_.setBrush( new SolidBrush(style.getFore()) );
        d.gc_.fillCircle( center_x, center_y, ry );
      }
    }
    
    //locate: if I found a region, and no needle over region and under point to locate,
    //use region founded...
    if( loc_region!= null )
    {
      throw loc_region;
    }
  }
  
  /**
   * Process an estimation to the radius you have to use to draw unit of axis, given an out_radius.
   * return negative radius to claim that there are no place for axis's unit in.
   * IGC's Font must be set before.. 
   */
  private static int estimateUnitRadius( DefaultChartRenderData d, DAxis axis, IScale scale,  int center_x, int center_y, int out_radius )
  {
    Object step = axis.getProperties().get( DAxis.P_STEP_UNIT );
    if ( step ==null ) return -1;
    
    int unit_radius = out_radius;
    for( Object vs = scale.stepFirst(step); vs!=null;  vs=scale.stepNext(step,vs) )
    {
      ISize size = d.gc_.textExtent( scale.valueText(vs) );
      double a = scale.toScale( vs );
      
      double vr=unit_radius;
      do
      {
        int vurx = (int)((unit_radius)*Math.cos(a));
        int vury = (int)((unit_radius)*Math.sin(a));
        int tw = size.getW();
        int th = size.getH();
        int dvx =tw, dvy=-th;
        
        //try to place text in a less silly way...
        if ( a < 0.5*Math.PI ) {}/*raf*/
        else if ( a <= Math.PI    ) { dvx=-tw; }
        else if ( a < 1.5*Math.PI ) { dvx=-tw; dvy=th; }
        else                        { dvy=th; };
        int vrx = vurx + dvx, vry = vury+dvy;
        vr = Math.sqrt( vrx*vrx+ vry*vry );
        if( vr >= out_radius )
        {
          //doesn't fit in... reduce unit_radius.
          //this is a rough algorithm: reduce-and-retry, because formula is made of square'n cos'n sinus
          //invert it to get result in one step is a hard work I don't have .... time to do (;-%).
          unit_radius -= d.dpiX(3);
          if( unit_radius < 0 ) return -1; //no place...
        }
      } 
      while( vr >= out_radius );
    }
    
    return unit_radius;
  }
  
}
