/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultChartRenderStackBars.java,v 1.3 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 14 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.chart.internal;

import java.util.Vector;
import java.util.Iterator;

import org.eclipse.tptp.platform.report.core.internal.*;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;


/**
 * 
 * Default Render for Stack Bar graphic.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DefaultChartRenderStackBars
{
  private static class Point
  {
    CurveStyle cs; //only ref to curve style, do not dispose here.
    DPoint point;
    IDCoord coord;
  }
  private static class Bar implements IDisposable
  {
    /**store cumulative value of point for this bar, only is axis_use_numbers is true. */
    public double sum;
    public Vector points = new Vector(); //list of Point
    /** one point of the bar have a label, this store the first encountered */
    public DText label;  
    /** specific style for label, if null use RPDSBars.sty_axis instead */
    public IGCDStyle label_style;
    /** store text from label, of formated sums */
    public String text;
    public void dispose()
    {
/*TODO:remove IDisposable      
      if(label_style!=null) label_style.dispose();
*/      
    }
  }
  private static class RPDSBars implements IDisposable
  {
    public DAxis axis;
    public boolean axis_use_numbers;
    public IDAlignment label_alignment;
    public IGCDStyle sty_axis;
    public IScale scale ;
    public Insets am;
    public int available_labels_height;
    public Vector bars ;
    public boolean thin_bar;
    float  wbartobar, wbar, xdecbar ;
    int _3d_z;
    
    public void dispose()
    {
//TODO:remove      if( sty_axis!=null) sty_axis.dispose();
      if( bars!=null)
      for( Iterator it=bars.iterator(); it.hasNext() ; )
      {
        ((Bar)it.next()).dispose();
      }
    }
  }
  
  /**
   * Render T_STACKBARS graphics
   */
  public static void render( DefaultChartRenderData d, RenderPersistData rpd )
     throws DefaultRenderChartLocation
  {
    RPDSBars p = null;
    if( rpd.g instanceof RPDSBars ) p = (RPDSBars)rpd.g;
    //need rebuild ?
    if( p ==null )
    {
      p = rebuildData( d, rpd );
    }
    
    if( p.axis==null )
    {
      if( d.drawing()) d.error("Error: Missing axis", rpd );
      return ;
    }
    if( !p.scale.isValid() )
    {
      if( d.drawing()) d.error("Error: invalid scale", rpd );
      return ;
    }

    int n_bars = p.bars.size();
    if( n_bars==0 ) return ;

    double xbar = rpd.ag_rect.left();
    double ybase = p.scale.getScaleForBar();

    //not an error, just not enough place
    if( rpd.ag_rect.w()<=0 || rpd.ag_rect.h()<=0 ) return ;

    LineStylePen pen = new LineStylePen();
    
    //draw Y axis (see locating below)
    d.renderYAxis( true, true, true, p.axis, p.scale, rpd.ag_rect, p.am, p.sty_axis, IDAlignment.ROTCCW90, p._3d_z,p._3d_z );
    //axis base lines ...
    if( d.drawing() )
    {
      pen.setRGBA( p.sty_axis.getFore() );
      d.gc_.setPen( pen );
      int left = rpd.ag_rect.left();
      d.gc_.drawLine( left, rpd.ag_rect.top(), left, rpd.ag_rect.bottom() );
      d.gc_.drawLine( left, (int)ybase, rpd.ag_rect.right(), (int)ybase );
    }

    Object val=null;
    Rect r = new Rect();
    //need to check all bar (due to 3d effect)
    DefaultRenderChartLocation last_loc=null;
    
    IShape save_clip=null;
    
    if( d.drawing())
    {
      save_clip = d.gc_.getClipping();
    }
    
    int label_alignment = p.label_alignment.getAlignment();
    for( Iterator it=p.bars.iterator(); it.hasNext(); )
    {
      Bar bar = (Bar)it.next();
      
      if( d.drawing()) 
      {
        d.gc_.setClipping( new Rect( rpd.ag_rect.x(), rpd.ag_rect.y()-p._3d_z, rpd.ag_rect.w()+p._3d_z+1, rpd.ag_rect.h()+p._3d_z ));
      } 
      double ypoint = ybase;
//TODO:test 100% ... but y axis must reflect this ... too     
//p.scale.setValueRange( new Double(0), new Double(bar.sum));    
      for( Iterator ip=bar.points.iterator(); ip.hasNext(); )
      {
        Point pt = (Point)ip.next();
        val = pt.coord.getValue( val );
        double ys = p.scale.toScale( val );
        double bh = ys-ybase;      
        int xb = (int)(xbar+p.xdecbar);
        r.setRect( xb, (int)ypoint, (int)(xbar+p.xdecbar+p.wbar-xb)/*round*/, (int)bh );
        r.normalize();
        ypoint += bh;
    
        try
        {
          d.renderBar( true, r, pt.cs.style_.getBack(), pt.point, p._3d_z );
        }
        catch( DefaultRenderChartLocation loc )
        {
          last_loc=loc;
        }
        
      }//points
      
      if( d.drawing() ) d.gc_.setClipping( null );
      
      //sums text or label under bar.
      IGCDStyle style = bar.label_style==null ? p.sty_axis : bar.label_style ;      
      d.gc_.setFont( style.getFont() );
      String txt = DrawUtilIGC.truncateText( d.gc_, bar.text, (int)p.wbartobar, p.available_labels_height, label_alignment );
      if( !DrawUtilIGC.isEmpty( txt ) )
      {
        IShape rc = d.gc_.getClipping(); //disable clipping of drawing area.
        d.gc_.setClipping(null);
        String id = bar.label != null ? DLocated.LabelText : DLocated.InAxisXUnit ;
        IDItem loc_item = bar.label != null ? (IDItem)bar.label : (IDItem)p.axis;
        Rect rtxt = new Rect( (int)xbar, rpd.ag_rect.bottom()+d.axis_unit_to_dot_spacing,
                              (int)p.wbartobar-d.dpiX(2), p.available_labels_height );
        d.renderText( txt, rtxt, label_alignment, style, id, loc_item );
        d.gc_.setClipping( rc ); //reset clipping.
      }
      
      xbar += p.wbartobar;
    }//bars
    
    if( save_clip !=null )
    {
      d.gc_.setClipping( save_clip );
    }
    if( last_loc !=null )
    {
      throw last_loc;
    }
    //time to do locating in Y axis..
    d.renderYAxis( true, false, true, p.axis, p.scale, rpd.ag_rect, p.am, p.sty_axis, IDAlignment.ROTCCW90, p._3d_z,p._3d_z );    
  }

  private static RPDSBars rebuildData( DefaultChartRenderData d, RenderPersistData rpd )
  {
    RPDSBars p = new RPDSBars();
    rpd.g = p;
    
    //get axis.
    for( IDItem i=rpd.graphic.getFirstChild(); i!=null; i=i.getNext() )
    {
      if(!(i instanceof DAxis)) continue;
      p.axis = (DAxis)i; //first seen, is good.
      break;
    }
  
    //axis is required 
    if( p.axis==null ) return p;
    p.axis_use_numbers = p.axis.useNumbers();    
    p.sty_axis = new IGCDStyle( p.axis, d.scale_ );
    
    { //check label alignment
      Object prop = p.axis.getProperties().get( DAxis.P_LABEL_ALIGNMENT );
      if( prop instanceof IDAlignment )
      {
        p.label_alignment = (IDAlignment)prop;
      } else {
        //use default alignment
        p.label_alignment = new DAlignment(IDAlignment.CENTER);
      }
    }
    
    //get bars values:
    p.bars = new Vector();
    
    for( int i=0; i< rpd.curve_styles.length; ++i )
    {
      CurveStyle cs = rpd.curve_styles[i];
      
      int ibar=0;
      
      for( IDItem ip=cs.curve_.getFirstChild(); ip!=null; ip=ip.getNext(), ibar++  )
      {
        if(!(ip instanceof DPoint)) continue;
        DPoint point = (DPoint)ip;
        //get first coordinate of this point on choosen axis.
        //add check if there are a label on it.
        DText label=null;
        IDCoord coord=null;
        for( IDItem ic=ip.getFirstChild(); ic!=null; ic=ic.getNext() )
        {
          if( ic instanceof DText )
          {
            if( label==null ) label = (DText)ic;
          }
          else if( ic instanceof IDCoord )
          {
            IDCoord crd = (IDCoord)ic;
            if( coord==null && crd.getAxis() == p.axis ) coord=crd; 
          }
          if( coord!=null && label!=null ) break;
        }
        //corresponding bar (coordinate MUST be found)
        if( coord!=null )
        {
          Bar bar = null;
          if( ibar>=p.bars.size() )
          {              
            bar = new Bar();
            bar.sum = 0;
            p.bars.add( bar );                              
          } else {
            bar = (Bar)p.bars.get(ibar);
          }
          //set label (or null)
          if( bar.label==null ) bar.label = label;
          //update sums:
          Point pp = new Point();
          pp.cs = cs;
          pp.point = point;
          pp.coord = coord;            
          bar.points.add( pp );
          //cumulate value only if axis use numbers
          if( p.axis_use_numbers )
          {
            double vp = ((Number)coord.getValue(null)).doubleValue();
            //!!absolute values only.            
            bar.sum += Math.abs( vp );
          }
        }
      }//points
    }//curves
    

    //prepare scale..
    Object v_min = p.axis.getProperties().get( DAxis.P_MIN );
    Object v_max = p.axis.getProperties().get( DAxis.P_MAX );
//must be compared to computed values:
//    if( v_min==null ) v_min = p.axis.getProperties().get( DAxis.P_MIN_HINT );
//    if( v_max==null ) v_max = p.axis.getProperties().get( DAxis.P_MAX_HINT );
    if( v_min==null || v_max==null )
    {
      //if I use numbers I can
      if( p.axis_use_numbers )
      {
        if( v_min==null ) v_min = new Double(0.0);
        if( v_max==null ) 
        {
          double max=0;
          boolean init=false;
          for( Iterator it=p.bars.iterator(); it.hasNext(); )
          {
            double b_sum = ((Bar)it.next()).sum;
            if( init ) max=Math.max( max, b_sum ); 
            else { max=b_sum; init=true; }
          }
          if( init )
          {
            v_max = new Double(max);
          }
        }
      }
      else
      {
        //else: user must set P_MIN, P_MAX properties if it use particular P_DATA_CLASS
        // but I can have P_Mxx_HINT properties set instead of P_Mxx
        if( v_min==null ) v_min = p.axis.getProperties().get( DAxis.P_MIN_HINT );
        if( v_max==null ) v_max = p.axis.getProperties().get( DAxis.P_MAX_HINT );
        //but no update bounds is done ... might use Comparable ?
      }
    }
    
    p.scale = DefaultChartRenderData.getScale( p.axis, 0,0, v_min,v_max );      
    p.am = d.computeYAxisAmounts(true, true, p.axis, p.scale, rpd.ag_rect, IDAlignment.ROTCCW90, null );
    
    //chart rect. is shrinked:
    rpd.ag_rect.setLeft( rpd.ag_rect.left()+ p.am.getL() );
    rpd.ag_rect.setTop( rpd.ag_rect.top() + p.am.getT() );
    rpd.ag_rect.setBottom( rpd.ag_rect.bottom() - p.am.getB() );

    int n_bars = p.bars.size();
    if( n_bars==0 ) return p;

    p.thin_bar  = rpd.graphic.getProperties().get( DGraphic.P_THIN_BAR, false );
    boolean _3d = rpd.graphic.getProperties().get( DGraphic.P_3D, false );

    final float kthinbar = p.thin_bar ? 0.7f : 1.0f;
    
    p.wbartobar = 0;
    
    if( _3d )
    {
      p.wbartobar = rpd.ag_rect.w()/(float)(n_bars+0.5*kthinbar);
    } else {
      p.wbartobar = rpd.ag_rect.w()/(float)(n_bars);
    }
    
    p.wbar = kthinbar*p.wbartobar;
    p.xdecbar= p.thin_bar ? (p.wbartobar-p.wbar)/2 : 0.0f;

    p. _3d_z = 0 ;
    if ( _3d )
    {
      p._3d_z = (int)(0.5f*p.wbar); 
      rpd.ag_rect.setWidth( rpd.ag_rect.w() - p._3d_z );
      rpd.ag_rect.setTop( rpd.ag_rect.top() + p._3d_z );
    }
    
    //sums values under bars or labels 
    int max_label_text_height = 0;
    for( Iterator I=p.bars.iterator(); I.hasNext(); )
    {
      Bar bar = (Bar)I.next();
      IGCDStyle style=p.sty_axis;
      if( bar.label != null )
      {
        bar.label_style = new IGCDStyle( bar.label, d.scale_ );
        style = bar.label_style;
        bar.text = bar.label.getText();
      }
      //use sum text ... only if axis use numbers
      else if( p.axis_use_numbers )
      {
        bar.text = p.scale.valueText(new Double(bar.sum));
      }
      if( bar.text!=null )
      {
        d.gc_.setFont( style.getFont() );
        int label_h = DrawUtilIGC.textExtent( d.gc_, bar.text, p.label_alignment.getAlignment() ).getH();
        if( label_h > max_label_text_height ) max_label_text_height = label_h;
      }
    }
    //limit the height of text ... we want to see bars !
    int labels_limit_height = (int)(0.5f*rpd.ag_rect.h());
    p.available_labels_height = Math.min( labels_limit_height, max_label_text_height );

    rpd.ag_rect.setBottom( rpd.ag_rect.bottom() - p.available_labels_height-d.axis_title_to_unit_spacing);

    //set pixels location for scale
    p.scale.setScaleRange( rpd.ag_rect.bottom(), rpd.ag_rect.top() );
    return p;
  }
}
