/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultChartRenderXYZ.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.core.internal.*;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.HSV;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.Point2D;
import org.eclipse.tptp.platform.report.drawutil.internal.Point3D;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;


/**
 * Default Chart Render for T_XYZ, T_WIREFRAME graphics
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DefaultChartRenderXYZ
{
  //internal identifier
  private static final int XProj=1;
  private static final int YProj=2;
  private static final int ZProj=3;
  private static final int Curve=4;
  private static final int Finished=5;
  
  //identifiers for axis X,Y,Z...
  private static final int AxisX = 1;
  private static final int AxisY = 2;
  private static final int AxisZ = 3;
  
  /** variant part of pertistent data for XYZ graphic */
  static class XYZ implements IDisposable
  {
    DAxis x_axis, y_axis, z_axis;
    IGCDStyle x_axis_style, y_axis_style, z_axis_style ;
    IScale x_scale, y_scale, z_scale ;
    
    Box3D bbox;
    boolean is_wireframe;
    
    public void dispose()
    {
/*TODO:remove IDisposable      
      if( x_axis_style !=null ) x_axis_style.dispose();
      if( y_axis_style !=null ) y_axis_style.dispose();
      if( z_axis_style !=null ) z_axis_style.dispose();
*/      
    }
  }
  /** 
   * Used for XYZ rendering: force all coordinate to have same value,
   * simple, but very useful to render the projection of a XYZ curve on a XY plan
   * (for exemple).
   */
  private static class ForceCoord implements ICoordTransformation
  {
    public double value_ = 0.0f;
    public double apply( double _f ) { return value_; }
  }

  //TBD: need to not be static for multi-threaded ?
  private static ForceCoord force_coord  = new ForceCoord();
  private static ForceCoord force_coord2 = new ForceCoord();


  /** 
   * Render XYZ curves (and 'simple' wireframe).
   * Rendering is made AsIs, no Z-Buffer, no hidden face remove algorythm, here is a simple
   * 3D drawing.
   */
  public static void render( DefaultChartRenderData d, RenderPersistData rpd )
     throws DefaultRenderChartLocation
  {
    //decorations means axis title/units...
    boolean display_decorations = true;

    XYZ p = null;   
    if( rpd.g instanceof XYZ ) p =(XYZ)rpd.g;

    //rebuild data ?
    if( p==null )
    {
      p = rebuildPersistData( d, rpd, display_decorations );
    }
    
    //missed axis ?
    if ( p.x_axis==null || p.y_axis==null || p.z_axis==null )
    {
      if( d.drawing())
      {
        String txt = "Error: missing ";
        boolean comma=false;
        if(p.x_axis==null) { txt +="'x'"; comma=true; }
        if(p.y_axis==null) {
          if(comma) txt +=", ";
          txt += "'y'";
          comma=true;
        }
        if(p.y_axis==null) {
          if(comma) txt +=", ";
          txt += "'z'";
          comma=true;
        }
        txt += " axis";
        d.error( txt, rpd );
      }
      return ;
    }

    //two angle to drive view
    double phi   = rpd.graphic.getProperties().get( DGraphic.P_XYZ_PHI,   0.3 );
    double theta = rpd.graphic.getProperties().get( DGraphic.P_XYZ_THETA, 0.2 );

    View3D view = new View3D( phi, theta, 0, 1.0f, p.bbox );

    //scale 3D view for rendering if gR rectange
    int rg_w = rpd.ag_rect.w();
    int rg_h = rpd.ag_rect.h();
    view.scaleTo( rpd.ag_rect.x(), rpd.ag_rect.y(), rg_w, rg_h );

    int min_w_h = rg_w ;
    if (min_w_h > rg_h ) min_w_h = rg_h;

    // coordinate used for curve projection.
    double x_proj = p.bbox.getXMin(), y_proj=p.bbox.getYMin(), z_proj=p.bbox.getZMin(); 

    LineStylePen pen = new LineStylePen();
    
    //bounding Box
    if ( display_decorations )
    {
      if( d.drawing() )
      {
//TODO: use P_LINE_COLOR from the  3 axis ... but with one of the 3 ?
        pen.setRGBA( RGBA.LIGHT_GRAY );
        d.gc_.setPen( pen );
        drawBox3D( d, view, p.bbox );
      }

      // render the 3 axis..
      renderAnAxis3D( d, view, p.bbox, p.x_axis, p.x_scale, p.x_axis_style, AxisX );
      renderAnAxis3D( d, view, p.bbox, p.y_axis, p.y_scale, p.y_axis_style, AxisY );
      renderAnAxis3D( d, view, p.bbox, p.z_axis, p.z_scale, p.z_axis_style, AxisZ );
    }

    CurveStyle  ccurve =null;
    CurveStyle p_ccurve=null; //previous curve used to render WIREFRAME
    double     last_x=0, last_y=0;

    //lighter color to draw projection...
    int background_color = rpd.g_style.getBack();
    HSV bhsv = new HSV( background_color );

    // check property status for curves projections
    boolean do_xproj = rpd.graphic.getProperties().get( DGraphic.P_XYZ_XPROJ, true);
    boolean do_yproj = rpd.graphic.getProperties().get( DGraphic.P_XYZ_YPROJ, true);
    boolean do_zproj = rpd.graphic.getProperties().get( DGraphic.P_XYZ_ZPROJ, true);

    Point2D pt = new Point2D();
    Object  vp = null;
    Point3D p3c = new Point3D();
    Point3D p3l = new Point3D();
    
    int proj_color = 0;
    
    for( int ic=0; ic<rpd.curve_styles.length; ++ic )
    {
      ccurve = rpd.curve_styles[ic];
      //curve is rendered 4 times: X, Y, Z projections and the curve it self.
      int what=XProj;

      if( display_decorations
       && d.drawing() // in locating mode projection aren't rendered
        )
      {
        //for projection color is lighter than curve color...
        proj_color = RGBA.Lighter( ccurve.style_.getBack(), 0.75f );
        HSV hsv = new HSV( proj_color );
        //but must be mixed with background color...
        //don't ask me why 20 is here ... this is a fine tuned heuristic ! (yes indeed)
        int ecart=(int)(Math.abs(bhsv.getV()-hsv.getV())+Math.abs(bhsv.getS()-hsv.getS()))>>1;
        if(ecart < 20 )
        {
          //background color is too close ... prefere a darker color for curve projection
          proj_color = RGBA.Darker( ccurve.style_.getBack(), 0.5f );
        }
        pen.setRGBA( proj_color );
        d.gc_.setPen( pen );
        what = XProj ;
      } else {
        what = Curve ;
      }
      
      for( ;what<Finished; )
      {
        view.resetCoordTransformation();
        //configure coordinate transformation for projections...
        switch( what )
        {
          case XProj: { if(!do_xproj) { what=YProj; continue; }
                        force_coord.value_  = x_proj ;
                        view.setXCoordTransformation( force_coord );
                        what = YProj;
                        break; }
          case YProj: { if(!do_yproj) { what=ZProj; continue; }
                        force_coord.value_ = y_proj ;
                        view.setYCoordTransformation( force_coord );
                        what = ZProj;
                        break; }
          case ZProj: { if(!do_zproj) { what=Curve; continue; }
                        force_coord.value_ = z_proj ;
                        view.setZCoordTransformation( force_coord );
                        what = Curve;
                        break; }
          case Curve: { if(d.drawing()) { pen.setRGBA( ccurve.style_.getBack() ); d.gc_.setPen(pen); } 
                        what = Finished;
                        break; }
          case Finished:break;
        }//switch

        boolean first=true; 
        DPoint curr_curve_prev_point=null;
        DPoint prev_curve_curr_point=null;
        //initialise previous curve point (for wireframe only)
        if( p.is_wireframe && p_ccurve!=null )
        {
          for( IDItem it=p_ccurve.curve_.getFirstChild(); it!=null; it=it.getNext() )
          {
            if(!(it instanceof DPoint)) continue;
            prev_curve_curr_point = (DPoint)it;
            break;//found first point of previous curve.
          }
        }
        //for each point of current curve
        for( IDItem item = ccurve.curve_.getFirstChild(); item!=null; item=item.getNext() )
        {
          if( !(item instanceof DPoint)) continue;
          DPoint curr_curve_curr_point   = (DPoint)item;
          
          if( getPoint( curr_curve_curr_point, p, vp, p3c ) ) //have all 3 axis in this point ?
          {
            double p_x,p_y;
            view.projection( p3c.getX(), p3c.getY(), p3c.getZ(), pt );
            {
              p_x = pt.getX();
              p_y = pt.getY();
              if ( first )
              {
                first=false;
              }
              else
              {
                if(d.drawing())
                {
                  d.gc_.drawLine( (int)last_x, (int)last_y, (int)p_x, (int)p_y );
                }
                else //locating
                {
                  if( what==Finished ) //only when render curve (no projection)
                  {
                    if( DrawUtilIGC.segmentContains( (int)last_x, (int)last_y, (int)p_x, (int)p_y, d.lx_,d.ly_))
                    {
                      DefaultRenderChartLocation loc
                      = new DefaultRenderChartLocation( DLocated.CurveLine, curr_curve_curr_point,
                          new Rect((int)p_x,(int)p_y, (int)(last_x-p_x),(int)(last_y-p_y) ));
                      loc.setPreviousPoint( curr_curve_prev_point );
                      throw loc;
                    }
                  }
                }
              }
            }
            last_x=p_x;
            last_y=p_y;
            
            //link with previous curve point (WIREFRAME only)
            if ( getPoint( prev_curve_curr_point, p, vp, p3l ))
            {
              view.projection( p3l.getX(), p3l.getY(), p3l.getZ(), pt);
              double p_p_x = pt.getX(),  p_p_y=pt.getY();
              if( d.drawing() )
              {
                d.gc_.drawLine( (int)p_x,(int)p_y, (int)p_p_x,(int)p_p_y);
              } 
              else // locating
              {
                if( what==Finished )
                {
//TBD: several curve may overlay ...                       
                  if( DrawUtilIGC.segmentContains( (int)p_x,(int)p_y, (int)p_p_x,(int)p_p_y, d.lx_,d.ly_ ))
                  {
                    DefaultRenderChartLocation loc
                    = new DefaultRenderChartLocation( DLocated.CurveLine, prev_curve_curr_point, 
                        new Rect( (int)p_x,(int)p_y,(int)(p_p_x-p_x),(int)(p_p_y-p_y)));
                    loc.setPreviousPoint( curr_curve_curr_point );
                    throw loc;
                  } 
                }
              }
              //goto next point of previous curve
              for( IDItem it=prev_curve_curr_point.getNext(); it!=null; it=it.getNext())
              {
                if(!(it instanceof DPoint)) continue;
                prev_curve_curr_point=(DPoint)it;
                break;
              }
            }
          }
          
          curr_curve_prev_point = curr_curve_curr_point;
        }//for

      }//for:what

      p_ccurve=ccurve;
    }//for

  }

  private static XYZ rebuildPersistData( DefaultChartRenderData d, RenderPersistData rpd, boolean display_decorations )
  {
      XYZ p = new XYZ();
      rpd.g = p;

      p.is_wireframe = rpd.graphic.isRenderableId( DGraphic.T_WIREFRAME );

      //retrieve the 3 required axis ...
      p.x_axis = null;
      p.y_axis = null;
      p.z_axis = null;
      int   axis_missed = 3;
      //get the 3 axis ...
      for( IDItem item = rpd.graphic.getFirstChild(); item!=null; item=item.getNext() )
      {
        if( !(item instanceof DAxis) ) continue;
        
        DAxis axis = (DAxis)item;
        if( p.x_axis==null && "x".equals( axis.getName() ))
        {
          p.x_axis = axis; axis_missed--;
        }
        else if ( p.y_axis==null & "y".equals( axis.getName() ))
        {
          p.y_axis = axis; axis_missed--;
        }
        else if ( p.z_axis==null & "z".equals( axis.getName() ))
        {
          p.z_axis = axis; axis_missed--;
        }
        if( axis_missed==0 ) break;
      }

      //one axis missed, can't go further
      if( axis_missed!=0 )
      {
        return p;
      }
      
      p.x_axis_style = new IGCDStyle( p.x_axis, d.scale_ );
      p.y_axis_style = new IGCDStyle( p.y_axis, d.scale_ );
      p.z_axis_style = new IGCDStyle( p.z_axis, d.scale_ );

      //keep a little space for text on axis...
      //this is completly choosen "as-is"
      int max_font_h  = 0 ;
      if ( display_decorations )
      {
        d.gc_.setFont( p.x_axis_style.getFont() );
        max_font_h = d.gc_.getFontMetrics().getHeight();
        d.gc_.setFont( p.y_axis_style.getFont() );
        int hf = d.gc_.getFontMetrics().getHeight();
        if ( max_font_h < hf ) max_font_h = hf;
        d.gc_.setFont( p.z_axis_style.getFont() );
        hf = d.gc_.getFontMetrics().getHeight();
        if ( max_font_h < hf ) max_font_h = hf;
        max_font_h = 2*max_font_h +6;
      }
 
      //rectangle of drawing area is...
      rpd.ag_rect.setRect( rpd.ag_rect.left()+max_font_h, rpd.ag_rect.top()+max_font_h,
                           rpd.ag_rect.w()-2*max_font_h,  rpd.ag_rect.h()-max_font_h );

      //bounding box for curve to render
      //curve (axis) can use any Object as value...
      Object x_min = p.x_axis.getProperties().get( DAxis.P_MIN );
      Object x_max = p.x_axis.getProperties().get( DAxis.P_MAX );
      Object y_min = p.y_axis.getProperties().get( DAxis.P_MIN );
      Object y_max = p.y_axis.getProperties().get( DAxis.P_MAX );
      Object z_min = p.z_axis.getProperties().get( DAxis.P_MIN );
      Object z_max = p.z_axis.getProperties().get( DAxis.P_MAX );
      
      if( x_min==null || x_max == null || y_min==null || y_max == null || z_min==null || z_max == null  )
      {
        MinMax x_mm = new MinMax( p.x_axis );
        MinMax y_mm = new MinMax( p.y_axis );
        MinMax z_mm = new MinMax( p.z_axis );
        
        for( int icrv=0; icrv < rpd.curve_styles.length; ++icrv )
        {
          for( IDItem ip=rpd.curve_styles[icrv].curve_.getFirstChild(); ip!=null; ip=ip.getNext() )
          {
            for( IDItem ic=ip.getFirstChild(); ic!=null; ic=ic.getNext() )
            {
              if( !(ic instanceof IDCoord) ) continue;
              IDCoord coord = (IDCoord)ic;
              DAxis axis = coord.getAxis();
                   if( axis==p.x_axis ) x_mm.update( coord );
              else if( axis==p.y_axis ) y_mm.update( coord );
              else if( axis==p.z_axis ) z_mm.update( coord );
            }
          }
        }
        if( x_min==null ) x_min = x_mm.getVMin();
        if( x_max==null ) x_max = x_mm.getVMax();
        if( y_min==null ) y_min = y_mm.getVMin();
        if( y_max==null ) y_max = y_mm.getVMax();
        if( z_min==null ) z_min = z_mm.getVMin();
        if( z_max==null ) z_max = z_mm.getVMax();
      }

//TODO: by default choose -1,+1 for each coords, the result will be a box, but
//each coords have different scale (due to different min/max). Perhaps it'll be
//a good idea to have a 'normed' property to force same scale for axis having same
//kind of P_DATA_CLASS.
//TBD:test:
if( p.x_axis.useNumbers() && p.y_axis.useNumbers() && p.z_axis.useNumbers() 
 && p.x_axis.isScaleType( DAxis.S_LIN )
 && p.y_axis.isScaleType( DAxis.S_LIN )
 && p.z_axis.isScaleType( DAxis.S_LIN )
 )
//TODO: en fait il faut les "normer" les axes communs, il peut y en avoir 1 ou 2 (3D)
{
  double xmin = ((Number)x_min).doubleValue(), xmax = ((Number)x_max).doubleValue();
  double ymin = ((Number)y_min).doubleValue(), ymax = ((Number)y_max).doubleValue();
  double zmin = ((Number)z_min).doubleValue(), zmax = ((Number)z_max).doubleValue();
  double kx = (xmax-xmin); // /(smax-smin)
  double ky = (ymax-ymin); // /(smax-smin)
  double kz = (zmax-zmin); // /(smax-smin)
 
  //choose max coef...
  double k = Math.max( kx, Math.max( ky, kz ));
  //choose smin=0 for all axis.
  double x_smax = kx / k;
  double y_smax = ky / k;
  double z_smax = kz / k;

      p.x_scale = DefaultChartRenderData.getScale( p.x_axis, 0,x_smax, x_min,x_max );
      p.y_scale = DefaultChartRenderData.getScale( p.y_axis, 0,y_smax, y_min,y_max );
      p.z_scale = DefaultChartRenderData.getScale( p.z_axis, 0,z_smax, z_min,z_max );
}
else
{
  //non normative scales...
      p.x_scale = DefaultChartRenderData.getScale( p.x_axis, -1,1, x_min,x_max );
      p.y_scale = DefaultChartRenderData.getScale( p.y_axis, -1,1, y_min,y_max );
      p.z_scale = DefaultChartRenderData.getScale( p.z_axis, -1,1, z_min,z_max );
}

      p.bbox = new Box3D( p.x_scale.getScaleMin(), p.x_scale.getScaleMax(),
                          p.y_scale.getScaleMin(), p.y_scale.getScaleMax(),
                          p.z_scale.getScaleMin(), p.z_scale.getScaleMax()  );

      return  p;
  }

  /** draw the 3D box using view */
  private static void drawBox3D( DefaultChartRenderData _d, View3D _view, Box3D _bb )
  {
    Point2D p[] = new Point2D[8];
    double xn = _bb.getXMin(), xx = _bb.getXMax();
    double yn = _bb.getYMin(), yx = _bb.getYMax();
    double zn = _bb.getZMin(), zx = _bb.getZMax();
    p[0] = _view.projection( xn,yn,zn, new Point2D() );
    p[1] = _view.projection( xn,yn,zx, new Point2D() );
    p[2] = _view.projection( xx,yn,zx, new Point2D() );
    p[3] = _view.projection( xx,yn,zn, new Point2D() );
    p[4] = _view.projection( xn,yx,zx, new Point2D() );
    p[5] = _view.projection( xx,yx,zx, new Point2D() );
    p[6] = _view.projection( xx,yx,zn, new Point2D() );
    p[7] = _view.projection( xn,yx,zn, new Point2D() );

    _d.gc_.drawLine( (int)p[0].getX(),(int)p[0].getY(), (int)p[1].getX(),(int)p[1].getY());
    _d.gc_.drawLine( (int)p[0].getX(),(int)p[0].getY(), (int)p[3].getX(),(int)p[3].getY());
    _d.gc_.drawLine( (int)p[0].getX(),(int)p[0].getY(), (int)p[7].getX(),(int)p[7].getY());
    _d.gc_.drawLine( (int)p[2].getX(),(int)p[2].getY(), (int)p[1].getX(),(int)p[1].getY());
    _d.gc_.drawLine( (int)p[2].getX(),(int)p[2].getY(), (int)p[3].getX(),(int)p[3].getY());
    _d.gc_.drawLine( (int)p[2].getX(),(int)p[2].getY(), (int)p[5].getX(),(int)p[5].getY());
    _d.gc_.drawLine( (int)p[4].getX(),(int)p[4].getY(), (int)p[1].getX(),(int)p[1].getY());
    _d.gc_.drawLine( (int)p[4].getX(),(int)p[4].getY(), (int)p[5].getX(),(int)p[5].getY());
    _d.gc_.drawLine( (int)p[4].getX(),(int)p[4].getY(), (int)p[7].getX(),(int)p[7].getY());
    _d.gc_.drawLine( (int)p[6].getX(),(int)p[6].getY(), (int)p[3].getX(),(int)p[3].getY());
    _d.gc_.drawLine( (int)p[6].getX(),(int)p[6].getY(), (int)p[5].getX(),(int)p[5].getY());
    _d.gc_.drawLine( (int)p[6].getX(),(int)p[6].getY(), (int)p[7].getX(),(int)p[7].getY());
  }
  
  private static void renderAnAxis3D( 
      DefaultChartRenderData _d,
      View3D _view, Box3D _bb,
      DAxis _axis, IScale _scale, IGCDStyle _axis_style, int _axis_type
    )
    throws DefaultRenderChartLocation
  {
    double x_proj = _bb.getXMin(), x_proj2 = _bb.getXMax(),
           y_proj = _bb.getYMin(), y_proj2 = _bb.getYMax(),
           z_proj = _bb.getZMin(), z_proj2 = _bb.getZMax();

    Point2D p0 = new Point2D(), 
            p1 = new Point2D(),
            p2 = new Point2D();

    LineStylePen pen = new LineStylePen();
    
    /* 
     * LINES
     */
    Object step = _axis.getProperties().get( DAxis.P_STEP_LINE );
    if ( _d.drawing() && step!=null )
    {
      pen.setRGBA(  _d.getLineColor( _axis ) );
      _d.gc_.setPen( pen );

      //more code but switch is done once..        
      switch( _axis_type )
      {
        case AxisX: for( Object vs=_scale.stepFirst(step); vs!=null; vs=_scale.stepNext(step,vs) )
                    {
                      double v = _scale.toScale( vs );
                      _view.projection( v, y_proj2, z_proj,  p0 );
                      _view.projection( v, y_proj,  z_proj,  p1 );
                      _view.projection( v, y_proj,  z_proj2, p2 );
                      
                      _d.gc_.drawLine( (int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY() );
                      _d.gc_.drawLine( (int)p2.getX(), (int)p2.getY(), (int)p1.getX(), (int)p1.getY() );
                    }
                    break;
       case AxisY: for( Object vs=_scale.stepFirst(step); vs!=null; vs=_scale.stepNext(step,vs) )
                   {
                     double v = _scale.toScale( vs );
                     _view.projection( x_proj2, v, z_proj,  p0 );
                     _view.projection( x_proj,  v, z_proj,  p1 );
                     _view.projection( x_proj,  v, z_proj2, p2 );
                     
                     _d.gc_.drawLine( (int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY() );
                     _d.gc_.drawLine( (int)p2.getX(), (int)p2.getY(), (int)p1.getX(), (int)p1.getY() );
                   }
                   break;
       case AxisZ: for( Object vs=_scale.stepFirst(step); vs!=null; vs=_scale.stepNext(step,vs) )
                   {
                     double v = _scale.toScale( vs );
                     _view.projection( x_proj2, y_proj,  v, p0 );
                     _view.projection( x_proj,  y_proj,  v, p1 );
                     _view.projection( x_proj,  y_proj2, v, p2 );
                     
                     _d.gc_.drawLine( (int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY() );
                     _d.gc_.drawLine( (int)p2.getX(), (int)p2.getY(), (int)p1.getX(), (int)p1.getY() );
                   }
                   break;
      }//switch
    }

    /*
     * Step Unit
     */
    boolean have_step_unit = false;
    
    step = _axis.getProperties().get( DAxis.P_STEP_UNIT );
    if ( step!=null )
    {
      have_step_unit = true;
      float d_angle = 0.0f;
      switch( _axis_type )
      {
        case AxisX:
            _view.projection( _bb.getXMin(),_bb.getYMin(),_bb.getZMin(), p0 );
            _view.projection( _bb.getXMax(),_bb.getYMin(),_bb.getZMin(), p1 );
            d_angle = 180;
          break;
        case AxisY:
             _view.projection( _bb.getXMin(),_bb.getYMin(),_bb.getZMin(), p0 );
             _view.projection( _bb.getXMin(),_bb.getYMax(),_bb.getZMin(), p1 );
             d_angle = 0;
           break;
        case AxisZ:
             _view.projection( _bb.getXMin(),_bb.getYMin(),_bb.getZMin(), p0 );
             _view.projection( _bb.getXMin(),_bb.getYMin(),_bb.getZMax(), p1 );
             d_angle = 180;
           break;
      }
       
      float angle = (float)Math.atan2( p1.getY()-p0.getY(), p1.getX()-p0.getX() ); //rad.
      angle = (float)(180*angle/Math.PI + d_angle); //degree

      if( _d.drawing() )
      {
        _d.gc_.setBrush( new SolidBrush( _axis_style.getFore() ) );
        _d.gc_.setFont( _axis_style.getFont() );
      }
      
      Rect rtxt = new Rect();
      int fh = _d.gc_.getFontMetrics().getHeight();
      
      for( Object vs = _scale.stepFirst(step); vs!=null; vs=_scale.stepNext(step,vs) )
      {
        double v = _scale.toScale( vs );
        switch( _axis_type )
        { 
          case AxisX: _view.projection(  v,      y_proj,  z_proj2, p2 ); break;
          case AxisY: _view.projection(  x_proj, v,       z_proj2, p2 ); break;
          case AxisZ: _view.projection(  x_proj, y_proj2, v,       p2 ); break;
        }
            
        String txt = _scale.valueText( vs );
        int wt = _d.gc_.textExtent( txt ).getW();
        rtxt.setRect( -wt/2, -3-fh, wt, fh );
        rtxt.moveBy( (int)p2.getX(), (int)p2.getY() );            

        if( _d.drawing() )
        {
          DrawUtilIGC.drawText( _d.gc_, rtxt, IDAlignment.CENTER, txt );
        }
        else //locating
        {
          //TBD....
        }
      }
    }

    /*
     * Axis title.
     */
    String axis_title = DefaultChartRender3D.axis3DName( _axis );
    if ( !DrawUtilIGC.isEmpty( axis_title ) )
    {
        String location=null;
        Rect rtxt = new Rect();
        int fh = _d.gc_.getFontMetrics().getHeight();       
        
        switch( _axis_type )
        {
          case AxisX:
                _view.projection( _bb.getXMin(),y_proj,z_proj2, p0 );
                _view.projection( _bb.getXMax(),y_proj,z_proj2, p1 );
               location = DLocated.InAxisXTitle;
            break;
          case AxisY:
                _view.projection( x_proj,_bb.getYMin(),z_proj2, p0 );
                _view.projection( x_proj,_bb.getYMax(),z_proj2, p1 );
                location = DLocated.InAxisYTitle; 
            break;

          case AxisZ:
                 _view.projection( x_proj,y_proj2,_bb.getZMin(), p0 );
                 _view.projection( x_proj,y_proj2,_bb.getZMax(), p1 );
                 location = DLocated.InAxisZTitle; 
            break;
        }

        double center_x=(p0.getX()+p1.getX())/2,
               center_y=(p0.getY()+p1.getY())/2;
        int wt = _d.gc_.textExtent( axis_title ).getW();
        rtxt.setRect( -wt/2, -6-2*fh, wt, fh );

        rtxt.moveCenter( (int)center_x, (int)center_y - (have_step_unit?(fh+4):0) -4 );

        if( _d.drawing() )
        {
          //SWT! I need rotation to render my text !
          DrawUtilIGC.drawText( _d.gc_, rtxt, IDAlignment.CENTER, axis_title );      
        }
        else //locating
        {
          if( rtxt.contains( _d.lx_, _d.ly_ ))
          {
            throw new DefaultRenderChartLocation( location, _axis, rtxt ); 
          }
        }
      }
    }
    
    /** true if ret contains all coodinates */
    private static boolean getPoint( DPoint point, XYZ p, Object vp, Point3D ret )
    {
      if( point==null ) return false;
      int coords = 0;
      for( IDItem icd=point.getFirstChild(); icd!=null; icd=icd.getNext() )
      {
        if(!(icd instanceof IDCoord)) continue;
        IDCoord coord = (IDCoord)icd;
        DAxis axis = coord.getAxis();
        if( axis == p.x_axis && ((coords&0x1)==0) )
        {
          ret.setX( p.x_scale.toScale( vp=coord.getValue(vp) ) );
          coords |= 0x1;
        }
        else if( axis == p.y_axis && ((coords&0x2)==0) )
        {
          ret.setY( p.y_scale.toScale( vp=coord.getValue(vp) ) );
          coords |= 0x2;
        }
        else if ( axis == p.z_axis && ((coords&0x4)==0) )
        {
          ret.setZ( p.z_scale.toScale( vp=coord.getValue(vp) ) );
          coords |= 0x4;
        }
      }
      
      return coords==0x7;
    }
}
