/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultRenderChartLocation.java,v 1.3 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 25 juin 2003.
 *
 */
package org.eclipse.tptp.platform.report.chart.internal;


import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.render.internal.IRenderLocation;


/**
 * Used to locate a point in a graphic render.
 * Id is a string to identify where is the point.
 * This a throwable because few default graphics an detect a location
 * without testing all possibility.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DefaultRenderChartLocation extends Throwable implements IRenderLocation
{
  /**
     * 
     */
    private static final long serialVersionUID = 1L;
/** id for location @see DLocated */
  protected String id_;
  /** associated item for location. */
  protected IDItem item_;
  /** area used for location */
  protected IRect rect_;
  /** used for location on text area, store displayed text */
  protected String displayed_text_;
  /** used for CurveSector, start and end angle of sector */
  protected int start_angle_, end_angle_;
  /** used for CurveLine, here is the previous point of segment */
  protected DPoint ppoint_;
  
  /**
   * Create a ChartLocation
   * @param _id identification of the location, @see DLocated
   * @param _item item associated to the location.
   * @param _rect rectangle where the location is valid.
   */
  public DefaultRenderChartLocation( String _id, IDItem _item, IRect _rect )
  {
    id_=_id;
    item_=_item;
    rect_=_rect;
  }
  /**
   * Create a ChartLocation
   * @param _id identification of the location, @see DLocated
   * @param _item item associated to the location.
   * @param _rect rectangle where the location is valid.
   * @param _dtxt displayed text
   */
  public DefaultRenderChartLocation( String _id, IDItem _item, Rect _rect, String _dtxt )
  {
    this( _id, _item, _rect );
    displayed_text_ = _dtxt;
  }
    
  /** @return id for the location, null if unknown */
  public String getId() { return id_; }
  /** @return item associated with this location */
  public IDItem getItem() { return item_; }
  /** @return rectangle where the location is still valid */
  public IShape getArea() { return rect_; }
  /** @return displayed text location have, or null */
  public String getDisplayedText() { return displayed_text_; }
 
  /** Set Displayed text */
  public void setDisplayedText( String _t ) { displayed_text_=_t; }
  
  /** start angle of located CurveSector */
  public int getStartAngle() { return start_angle_; }
  /** end angle of located CurveSector */
  public int getEndAngle() { return end_angle_; }
  /** Set angles */
  public void setAngles( int _start, int _end )
  {
    start_angle_=_start;
    end_angle_=_end;
  }
  
  /**@return previous point of CurveLine segment */
  public DPoint getPreviousPoint() { return ppoint_; }
  public void setPreviousPoint(DPoint pp)
  {
    ppoint_=pp;
  }
}
