/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IScale.java,v 1.5 2008/12/12 22:22:09 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 14 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.chart.internal;

import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.ULocale;


/**
 * Interface for class providing conversion between 'Object' value space and double space.
 * 'Object' used as generic value, but a real world might use Float,Double,Date,...
 * Ok, this is a good exercice for next templated class in java ...
 * First use of this is to convert Object to pixels for various graphics type.
 * 
 * @see Float, Double, Date
 * @see LinearNumberScale
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IScale
{
  /**
   * @return true is the scale is valid, and can be used to draw and convert...
   */
  public boolean isValid();
  
  /** @return double value from object value */
  public double toScale( Object _value );
  
  /** @return the value corresponding to double,
   * allocate a new value if parameter is null or can't be modified with value.
   */
  public Object toValue( double _dbl, Object _value );
  
  /**
   * Store in _value the highest value scale can take.
   * @return _value or new allocated object if _value is null (or have class that can be changed)
   */
  public Object getValueMax( Object _value );

  /**
   * Store in _value the lowest value scale can take.
   * @return _value or new allocated object if _value is null (or have class that can be changed)
   */
  public Object getValueMin( Object _value );
  
  /**
   * @return minimal double value.
   */
  public double getScaleMin();
  /**
   * 
   * @return maximal double value.
   */
  public double getScaleMax();
  
  /**
   * Change double bounds, ie: range.
   */
  public void setScaleRange( double _d_min, double _d_max );
  
  /**
   * Change values range
   */
  public void setValueRange( Object v1, Object v2 );
  
  /**
   * @return For given step, the first 'scaled' value. This method must be called once before
   * scaleNext(). Or null if steps can't be handled.
   */
  public Object stepFirst( Object _step );
  /**
   * @return For given step and value (returned by scaleFirst, for scaleNext), the next 'scaled' value. 
   *  or null if next step can't be done.
   */
  public Object stepNext( Object _step, Object _last );
  
  /**
   * @return the textual formatted text from a value, this text will be used for drawing.
   * The text format depends on the locale which is used.
   * If locale is null the current locale is used
   * @see com.ibm.icu.Format
   */
  public String valueText( Object Value );
  
  /**
   * Set the object formatter for text used by this scale.
   */
  public void setTextFormat( UFormat _format );
  
  /**
   * Set the locale for the text format.
   */
  public void setLocale( ULocale _locale );
  
  /**
   * @return true is this scale is a "reversed" scale. A reversed scale is a scale
   * where pixel for min. value is greate than pixel for max. value. in other words, for
   * an horizontal scale, a reversed scale is right to left.
   * This property is important when you want to compare locations, be care full of '>' and '<'.
   */
  public boolean isReversed();
  /**
   * Change the "reversed" property value for this scale. @see isReversed().
   */
  public void setReversed( boolean b );
  
  /**
   * @return double to use as the base for Bars of an histogram.
   * for example, if pixel scale deal with float values, this pixel correspond to value 0.0f
   * in the scale, of closest pixel to 0 value.
   */
  public double getScaleForBar();
}
