/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IXYSurface.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.internal;

/**
 * Interface used to define a XY Surface graphic type.
 * @see DXYSurface for an example of implementation
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public interface IXYSurface 
{
  /** @return the number of points along X axis */
  public int getSizeX();
  /** @return the number of points along Y axis */
  public int getSizeY(); 
  /** @return minimal value getZ() can return along Z axis */
  public double getZMin();
  /** @return maximal value getZ() can return along Z axis */
  public double getZMax();
  /** 
   * @return Z value for x, y points, x is from 0 to getSizeX()-1
   * y is from 0  to getSizeY()-1.
   */
  public double getZ( int x, int y );
}
