/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IXYSurfaceColorizer.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.internal;

/**
 * Used by XY Surface graphic type render to set a color for each face of
 * surface. 
 * @see IXYSurface, DGraphic
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public interface IXYSurfaceColorizer 
{
 /**
  * Return a color for given face of XY Surface.
  * @param x 0..1 (including) center of face along X axis.
  * @param y 0..1 (including) center of face along Y axis.
  * @param z 0..1 (including) center of face along Z axis.
  * @param cos_angle cosinus of angle between face normal and 3D point of view.
  * @return RGBA color for the given face.
  * @see RGBA class
  */
  public int getRGBA( double x, double y, double z, double cos_angle );
  
  /** 
   * @return true if graphic render must apply shadowing to color returned by getRGBA
   * method, false to use getRGBA color "as is".
   */
  public boolean isApplyShadow();
}
