/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Insets.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;


/**
 * Insets with Jscrib sauce ...
 * Hold four margins one for each directions...
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class Insets
{
  protected int left_, right_, top_, bottom_;
  
  public Insets()
  {
    left_=right_=top_=bottom_=0;
  }
  public Insets(int i)
  {
    left_=right_=top_=bottom_=i;
  }
  public Insets(int _left, int _right, int _top, int _bottom )
  {
    left_=_left;
    right_=_right;
    top_=_top;
    bottom_=_bottom;
  }
  public int getL() { return left_; }
  public int getR() { return right_; }
  public int getT() { return top_; }
  public int getB() { return bottom_; }
  public int getW() { return left_+right_; }
  public int getH() { return top_+bottom_; }
  
  public boolean isEmpty() { return left_==0 && right_==0 && top_==0 && bottom_==0; }
  
  public void reset() 
  {
    left_=right_=top_=bottom_=0;
  }
  
  public void setInsets( int _left, int _right, int _top, int _bottom )
  {
    left_=_left;
    right_=_right;
    top_=_top;
    bottom_=_bottom;
  }
  public void setInsets( int _len )
  {
    left_=right_=top_=bottom_=_len;
  }
  
  public void setL( int v ) { left_=v; }
  public void setR( int v ) { right_=v; }
  public void setT( int v ) { top_=v; }
  public void setB( int v ) { bottom_=v; }

  public void addL( int v ) { left_+=v; }
  public void addR( int v ) { right_+=v; }
  public void addT( int v ) { top_+=v; }
  public void addB( int v ) { bottom_+=v; }
  
  public void maxL( int v ) { if( v>left_) left_=v; }
  public void maxR( int v ) { if( v>right_) right_=v; }
  public void maxT( int v ) { if( v>top_) top_=v; }
  public void maxB( int v ) { if( v>bottom_) bottom_=v; }
  
  /**
   * Update insets using maxX method getting L,R,T,B from rect2 rectangle
   * if it is not contained inside base rectangle.
   * @param base   base rectangle to compute insets
   * @param rect2  secondary rectangle to get insets from base rectangle.
   */
  public void max( IRect base, IRect rect2 )
  {
    int l1 = Rect.Left( base ), r1 = Rect.Right( base );  
    int t1 = Rect.Top( base ),  b1 = Rect.Bottom( base );  
    int l2 = Rect.Left( rect2 ), r2 = Rect.Right( rect2 );  
    int t2 = Rect.Top( rect2 ),  b2 = Rect.Bottom( rect2 );
    if( l2 < l1 ) maxL( l1-l2 );
    if( r2 > r1 ) maxR( r2-r1 );
    if( t2 < t1 ) maxT( t1-t2 );
    if( b2 > b1 ) maxB( b2-b1 );
  }
  
  public String toString()
  {
    String s = super.toString()+"{l:"+left_+",r:"+right_+",t:"+top_+",b:"+bottom_+"}";
    return s;
  }
}