/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogNumberScale.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 14 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.tools.internal.VDouble;

/**
 * Logarythmic pixel scale suitable for double values only.
 * Note: Object used as  parameter and return are VDouble.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class LogNumberScale extends LinearNumberScale
{
  private double log_vmin_, log_vmax_;
  
  /**
   * Create a logarythmic pixel scale, vmin and vmax must be grater than zero
   * (and not equal to..)
   */
  public LogNumberScale( double scale_min, double scale_max, double vmin, double vmax )
  {
    super( scale_min, scale_max, Math.max(1e-10,vmin), Math.max( 1e-10, vmax) );
    setValueRange( vmin, vmax );
  }

  /**
   * Create a logarythmic pixel scale, vmin and vmax must be Numbers (Double,VDouble,...) grater than zero
   * (and not equal to..)
   */
  public LogNumberScale( double scale_min, double scale_max, Object vmin, Object vmax )
  {
    super( scale_min, scale_max, 0, 0 );
    setValueRange( vmin, vmax );
  }
  
  public boolean isValid()
  {
    return log_vmin_ < log_vmax_ ;
  }
  
  public void setValueRange( Object v1, Object v2 )
  {
    log_vmin_=-1; log_vmax_=-2;
    vmin_=-1; vmax_=-2;
    k_ = Double.NaN;
    if( !(v1 instanceof Number) ) return ;
    if( !(v2 instanceof Number) ) return ;
    setValueRange( ((Number)v1).doubleValue(), ((Number)v2).doubleValue() );
  }
  
  public void setValueRange( double d1, double d2 )
  {    
    if( d1 < d2 )
    {
      vmin_ = d1; vmax_ = d2 ;
    } else {
      vmin_ = d2; vmax_ = d1 ;
    }

    vmin_ = Math.max( 1e-10, vmin_); //no negative value
    vmax_ = Math.max( 1e-10, vmax_);

    log_vmin_ = Math.log( vmin_ );
    log_vmax_ = Math.log( vmax_ );
    k_ = log_vmax_==log_vmin_ ? Double.NaN : (dmax_-dmin_)/(log_vmax_-log_vmin_);
  }


  public double toScale( Object _value )
  {
    if( !(_value instanceof Number) ) return -1;
    double value = ((Number)_value).doubleValue();
    double scl;
    if( reverse_ )
    {
      scl = dmax_-(Math.log(value)-log_vmin_)/k_;
    } else {
      scl = dmin_+k_*(Math.log(value)-log_vmin_);
    }
    return scl;
  }
  
  public void setScaleRange( double scale_min, double scale_max )
  {
    super.setScaleRange( scale_min, scale_max );
    k_ = log_vmax_==log_vmin_ ? Double.NaN : (dmax_-dmin_)/(log_vmax_-log_vmin_);
  }
  
  public Object toValue( double scale, Object _value )
  {
    double val;
    if( reverse_ )
    {
      val = Math.exp( log_vmin_+(dmax_-scale)/k_ );
    } else {
      val = Math.exp( log_vmin_+(scale-dmin_)/k_ );
    }
    if( _value instanceof VDouble )
    {
      return ((VDouble)_value).setValue( val );
    }
    return new VDouble(val);
  }
  
  private double curr_step_, nlog_chgt_;
  
  public Object stepFirst( Object _step )
  {
    double step = -1;
    if( _step instanceof Number ) step = ((Number)_step).doubleValue();
    if( step <= 0.0f ) return null; // invalid _step.
//? add also _step >=10 ?    
    double base0=1;
    double v=vmin_;
    while( v < 1 ) { v*=10; base0*=0.1f; };
    while( v > 10 ) { v/=10; base0*=10f; };


    double v_for_step = (step*Math.ceil(v/step));
    double vdn= v_for_step*base0 ;

    nlog_chgt_ = base0*10;
    curr_step_ = step*base0;
//System.out.println("--scaleFirst("+_step+") vmin="+vmin_+" vmax="+vmax_+" v_for_step="+v_for_step+" v="+v+" base0="+base0);
//System.out.println("START: log_chgt="+nlog_chgt_+" rvalue="+curr_step_+" => vdn="+vdn);
    return new VDouble(vdn);
  }
 
  public Object stepNext( Object _step, Object _last )
  {
    if( !(_last instanceof VDouble ) ) return null; //invalid parameter.
    VDouble last_value = (VDouble)_last;
    double next = last_value.doubleValue() ;
    next += curr_step_;
    if( next > nlog_chgt_ )
    {
      curr_step_ *=10;
      next = curr_step_*Math.ceil(next/curr_step_);
      nlog_chgt_ *=10;
//System.out.println(" NEW rvalue="+curr_step_+" nlog_chgt="+nlog_chgt_+" scaleNext()=>"+_last);          
    }
    if( next > vmax_ ) return null;//stop
    return last_value.setValue( next );
  }

}
