/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MinMax.java,v 1.2 2008/05/23 14:11:50 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 13 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;

/**
 * UNDER DEVELOPMENT...
 * This class can be used to compute min/max values of a DCoord along an DAxis.
 * As we deal with min/max values must be of class java.lang.Comparable, this is very important.
 * This class compares proposed object. keeping trace of min and max values.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class MinMax
{
  /** store min/max value, null for invalid */  
  private  Comparable vmin, vmax;
  /** count invalid values (not Comparable) passed in update() method. */
  private int invalid_values;
  /** true if null_range flag is valid, false means must be computed */
  private boolean check_null_range ;
  /** true if min and max are same value */
  private boolean null_range ;
    
  /**
   * Create a Min/Max object,
   * initialise min/max with P_MIN_HIN/P_MAX_INT of axis, if they are Comparable
   */
  public MinMax( DAxis axis )
  {
    reset( axis );
  }
  
  /**
   * @return true if MinMax is valid, means have a min, have a max
   */
  public boolean isValid() { return vmin!=null && vmax!=null; }
  
  /**
   * @return true if is a null range. A null range is true if MinMax is invalid or
   * vmin and vmax have same value.
   */
  public boolean isNullRange()
  {
    if( check_null_range ) return null_range;
    check_null_range = false;
    null_range = (vmin==null) || (vmax==null) || ( vmin.compareTo( vmax )==0) ;
    return null_range;
  }
  
  /**
   * @return the minimum value. This is not a copy of the value: take care about modifying it's value.
   * @see isValid(), isNullRange()
   */
  public Comparable getVMin() { return vmin; }
  
  /**
   * @return the maximum value. This is not a copy of the value: take care about modifying it's value.
   * @see isValid(), isNullRange()
   */
  public Comparable getVMax() { return vmax; }

  /**
   * Reset Min/Max object.
   */
  public void reset()
  {
    vmin = vmax = null;
    invalid_values=0;
    check_null_range = true;
    null_range = true;
  }

  /**
   * Reset Min/Max object, and initialize using P_MIN_HINT,P_MAX_HINT if they are comparable.
   */
  public void reset( DAxis axis )
  {
    reset();
    
    if( axis ==null ) return ;
    Object min_hint = axis.getProperties().get( DAxis.P_MIN_HINT );
    Object max_hint = axis.getProperties().get( DAxis.P_MAX_HINT );
      
    if( min_hint instanceof Comparable )
    {
      vmin = toComparable( min_hint );
    }
    if( max_hint instanceof Comparable )
    {
      vmax = toComparable( max_hint );
    }
//System.out.println("_HINT=>  vn="+ vn +" vx="+vx);
  }
  
  /**
   * Propose value of IDCoord to update(Object) metho.
   * If coord. have value but isn't comparable, update invalid_coord flag.
   * @return true if min or max values changes.
   */  
  public boolean update( IDCoord coord )
  {
    if( coord==null ) return false ;
    
    Object vo = coord.getValue( null );
    return update( vo );
  }
  
  /**
   * Propose an Object, if Object is an instanceof Comparable value, update Min and Max comparing
   * this value. 
   * If coord. have value but isn't comparable, update invalid_coord flag.
   * @return true if min or max values changes.
   */  
  public boolean update( Object value )
  {
    if( value==null ) return false ;
    
    if( !(value instanceof Comparable) )
    {
      invalid_values++;
      return false;
    }
    
    Comparable v = toComparable( value );
    boolean changes = false;
    
    if( vmin==null || (vmin.compareTo( v ) > 0 ) )
    {
      vmin = v;
      changes=true;
    }
    
    if( vmax==null || vmax.compareTo( v ) < 0 )
    {
      vmax = v;
      changes=true;
    }

    return changes;
  }
   
  /**
   * @return number of invalid values.
   * @see update()
   */
  public int invalidValueCount() { return invalid_values; }
  
  
  private static Comparable toComparable( Object o )
  {
    //because java.lang.Integer.compareTo(Number) doesn't work if Number is a VDouble ??? strange.
    if( o instanceof Number )//do not share values:&& !(o instanceof VNumber) )
    {   
      return new Double( ((Number)o).doubleValue() );
    }
    return (Comparable)o;
  }
  
  public String toString()
  {
    String s = super.toString();
    s += "{ valid="+isValid()+" null_range="+null_range+" vmin="+vmin+"..vmax="+vmax+"}";
    return s;
  }
}