/* ***********************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RenderPersistData.java,v 1.5 2008/12/12 22:22:09 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 10 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.tools.internal.DAlignmentPair;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;

import com.ibm.icu.util.ULocale;


/**
 * Render Data that can persist from one render() call to an other one.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class RenderPersistData implements IDisposable
{
  public static final int V_TITLE  =0x01; //title data are valid.
  public static final int V_LEGEND =0x02; //legend data are valid.

  /** bit fields to store invalidation */
  int validity;
  
  /** Persist data is strongly associated with this graphic */
  public DGraphic graphic;
  /** The current locale */
  public ULocale locale;
  /** rectangle of graphic, stored to guess invalidation */
  public Rect  graphic_rect;
  /** keep trace of graphic type to invalidate data */
  public String graphic_type;
  /** image for wallpaper, null for none, this is stored in a DImageProvider, do not dispose here. */
  public IImage  g_wallpaper;
  /** effect of wallpaper */
  public int    e_wallpaper;
  
  /** style for graphic */
  public IGCDStyle g_style;
  
  /** Create a persistent data associated with given graphic */
  public RenderPersistData( DGraphic gph )
  {
    graphic = gph;
    validity=0; //since nothing is valid
    if (graphic!=null)
       locale = graphic.getLocale();
    else
       locale = null;
  }
  
  public boolean isValid( int mask ) { return (validity & mask)!=0; }
  public void validate( int mask ) { validity |= mask; }
  public void invalidate( int mask )
  {
    validity &= ~mask;
    //invalidate graphic private data too
    if( g!=null) g.dispose();
    g=null;
  }
  
  /** dispose resources hold by this "persistent" data */
  public void dispose()
  {    
//TODO:remove:    if( g_style!=null ) { g_style.dispose(); g_style=null; } 
/*TODO:remove:    if( curve_styles != null )
    {
      for( int i=0; i<curve_styles.length; ++i )
      {
        if( curve_styles[i]!=null ) curve_styles[i].dispose();
      }
      curve_styles=null;
    }*/
    if( g != null ) { g.dispose(); g=null; }
  }
  
  /** store show_title value at last compute time */
  boolean title_displayed ;
  /** store graphic title alignment */
  DAlignmentPair title_aln;
  /** store the title at last validation time */
  String title_text;
  /** store graphic title rectangle */
  Rect title_rect;
  /** store the displayed title (can be truncated, or equals to graphic.getTitle() */
  String title_displayed_text;
  /** store alignment used to render/locate */
  int title_render_aln ;
  
  /**store show_legend at lat render time */
  boolean legend_displayed ;
  /**store legend layout */
  DAlignmentPair legend_aln;
  /**store legend rectangle */
  Rect legend_rect;
  /**store max height/width of legend entries */
  int entry_max_width, entry_max_height;
  /**store legend symbol size */
  int legend_symbol_size;
  /**store layout direction */
  boolean legend_vertical_layout ;
  int legend_n_lines, legend_n_entry_by_line;
  
  
  /** store curves styles, legend/rendering have to use it */
  CurveStyle curve_styles [];
  
  public void rebuildCurveStyles( int n_curves, float _scale )
  {
    //dispose
    if( curve_styles != null )
    {
/*TODO:remove:      for( int i=0; i<curve_styles.length; ++i )
      {
        if( curve_styles[i]!= null )
        {
          curve_styles[i].dispose();
          curve_styles[i]=null;
        }
      }*/
      if( n_curves != curve_styles.length)
      {
        curve_styles = null;
      }
    }
    if( curve_styles==null )
    {
      curve_styles = new CurveStyle[n_curves];
    }
    
    int ic=0;
    for( IDItem item=graphic.getFirstChild(); item!=null; item=item.getNext() )
    {
      if( !(item instanceof DCurve) ) continue;
      DCurve curve = (DCurve)item;
      curve_styles[ic++] = new CurveStyle( curve, _scale );
    }
  }
  
  /**store rectangle for inner axis/graphic area (result of legend) */
  Rect ag_rect ;
  
  /** here his variant part for ... various graphic, null means need to rebuild */
  IDisposable g;

  /** for Histogram */
  static class Histogram implements IDisposable
  {
    DAxis axis;
    IGCDStyle axis_style;
    IScale y_scale;
    Insets yam;
    int n_bar, n_max_points_by_curve ;
    /** height of label aling horizontal axis 
     *  (might be max font height or text width due to 90 rotated alignment */
    int h_label_height;
    
    float wbartobar ; //width between bar, (bar width if not thin_bar)
    float wbar; //bar width
    float xdecbar; //shift due to wbar != wbartobar.
    int _3d_z; //!0 if "3d" effect is applied to bars.
    boolean thin_bar; //true if use thin bar (ie wbar<wbartobar)
    
    /** access to P_LABEL_ALIGNMENT property set on horizontal 'axis' */
    IDAlignment h_axis_alignment; 
    
    public void dispose()
    {
      if( axis_style!=null)
      {
//TODO:remove disposable:        axis_style.dispose();
        axis_style=null;
      }
    }
  }
}
