/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ICustomFormatter.java,v 1.2 2008/12/12 22:22:10 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal;

import com.ibm.icu.util.ULocale;


/**
 * <code>ICustomFormatter</code> is an interface that exploiters can
 * use to define a custom label format.   Exploiters will set specify
 * their class in their input file.  This interface only works when 
 * generating SVG charts.  SWT renderer does not make use of this 
 * capability.  Exploiters can specify a custom formatter class for 
 * various chart display text.  For more information to see what display
 * text can be custom formatted review the input schema file.
 */
public interface ICustomFormatter {
	
	/**
	 * format method will recieve a unformatted value along with the locale
	 * timezone and formatting pattern.  This function would format the 
	 * value based on the locale, timzone and pattern.  The formatted value
	 * is returned.
	 *  
	 * @param value the unformatted value
	 * @param locale the locale 
	 * @param timezone the timezone
	 * @param pattern the formatting pattern
	 * @return the formatted display value.
	 */
	String format(Object value, ULocale locale, String timezone, String pattern);
}
