/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGGeneratorException.java,v 1.2 2005/06/10 14:03:15 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGGeneratorException.java,v 1.2 2005/06/10 14:03:15 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/



/**
 * <code>SVGGemeratorException</code> and its subclasses is thrown by the SVG 
 * generator if the generation process failed.
 */
public class SVGGeneratorException extends Exception {

	/**
     * 
     */
    private static final long serialVersionUID = 1L;
    private Throwable cause = null;
	
	/**
	 * Constructs an SVGGeneratorException with no detailed message.
	 */
	public SVGGeneratorException() {
		super();
	}

	/**
	 * Constructs an SVGGeneratorException with a detailed message
	 * @param message the detail message. The detail message is saved for 
	 * later retrieval by the Throwable.getMessage() method.
	 */
	public SVGGeneratorException(String message) {
		super(message);
	}
	/**
	 * Constructs a new throwable with the specified cause and a detail 
	 * message of (cause==null ? null : cause.toString()) (which typically 
	 * contains the class and detail message of cause). 
	 * 
	 * @param cause the cause
	 */
	public SVGGeneratorException(Throwable cause) {
		super(cause.toString());
		this.cause = cause;
	}

	/**
	 * Override this method in the superclass to output the stack trace
	 * for the wrapped exception.
	 */
	public void printStackTrace() {
		super.printStackTrace();
		if (cause != null) {
			System.err.println("cause:");
			cause.printStackTrace();
		}
	}

	/**
	 * Override this method in the superclass in order to output the stack trace
	 * for the wrapped exception.
	 *
	 * @param s The stream to which the stack trace is written
	 */
	public void printStackTrace(java.io.PrintStream s) {
		super.printStackTrace(s);
		if (cause != null) {
			System.err.println("cause:");
			cause.printStackTrace(s);
		}
	}

	/**
	 * Override this method in the superclass in order to output the stack trace
	 * for the wrapped exception.
	 *
	 * @param s The writer to which the stack trace is written
	 */
	public void printStackTrace(java.io.PrintWriter s) {
		super.printStackTrace(s);
		if (cause != null) {
			System.err.println("cause:");
			cause.printStackTrace(s);
		}
	}
}
