/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.w3c.dom.Element;

/**
 * <code>ISVGBase</code> interface defines accessors for attributes which are common to 
 * a subset of the specified Scalable Vector Graphics (SVG) elements. Also provides for
 * accessing the generated implementation element. 
 * 

 * $Revision: 1.1 $
 */
public interface ISVGBase {
	
	/**
	 * Returns the identifier.
	 * @return String
	 */
	String getIdentifier();
	
	/**
	 * Returns the style.
	 * @return String
	 */
	String getStyle();

	/**
	 * Returns the style class.
	 * @return String
	 */
	String getStyleClass();
	
	/**
	 * Returns the visiblity setting.
	 * @return visibility setting
	 */
	String getVisibility();
		
	/**
	 * Sets the identifier for the element.
	 * @param identifier The identifier to set.
	 */
	void setIdentifier(String identifier);
	
	/**
	 * Sets the style for the element.
	 * @param style The style to set.
	 */
	void setStyle(String style);

	/**
	 * Sets the style class for the element.
	 * @param styleClass The styleClass to set.
	 */
	void setStyleClass(String styleClass);	

	/**
	 * Sets the visibility setting for the element.
	 * @param visibility Visibility setting
	 */
	void setVisibility(String visibility);	

	/**
	 * Returns the implementation element.
	 * @return Element
	 */
	Element getImplementation();	
}
