/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGContainerBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGContainerBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <code>ISVGContainerBase</code> interface defines accessors for attributes which are 
 * common to a subset of the specified Scalable Vector Graphics (SVG) elements; in particular,
 * those which act as containers. Also provides for accessing the objects which implement
 * container elements. 
 * 

 * $Revision: 1.1 $
 */
public interface ISVGContainerBase {
	
	/**
	 * Returns the array of contained objects.
	 * @return SVGGraphicBase[]
	 */
	SVGBase[] getChildren();

	/**
	 * Returns the description text.
	 * @return String
	 */
	String getDesc();

	/**
	 * Returns the title text.
	 * @return String
	 */
	String getTitle();
	
	/**
	 * Sets the array of contained objects.
	 * @param children The children to set.
	 */
	void setChildren(SVGBase [] children);
	
	/**
	 * Sets the description text.
	 * @param desc The desc to set
	 */
	void setDesc(String desc);
	/**
	 * Sets the title text.
	 * @param title The title to set
	 */
	void setTitle(String title);
	
}
