/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGDocumentFragmentBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGDocumentFragmentBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <code>ISVGDocumentFragmentBase</code> interface defines accessors for attributes which are 
 * common to Scalable Vector Graphics (SVG) "svg" elements. 
 * 

 * $Revision: 1.1 $
 */
public interface ISVGDocumentFragmentBase {

	/**
	 * Returns the width.
	 * @return String
	 */
	String getWidth();
		
	/**
	 * Returns the height.
	 * @return String
	 */
	String getHeight();
	
	/**
	 * Returns the xCoordinate.
	 * @return String
	 */
	String getXCoordinate();

	/**
	 * Returns the yCoordinate.
	 * @return String
	 */
	String getYCoordinate();
	
 	/** Returns the viewbox.
	 * @return String
	 */
	String getViewbox();

	/**
	 * Returns the preserveAspectRatio.
	 * @return String
	 */
	String getPreserveAspectRatio();

	/**
	 * Sets the width.
	 * @param width A non-negative value
	 */
	void setWidth(String width);

	/**
	 * Sets the height.
	 * @param height A non-negative value
	 */
	void setHeight(String height);
	
	/**
	 * Sets the xCoordinate.
	 * @param xCoordinate The xCoordinate to set
	 */
	void setXCoordinate(String xCoordinate);

	/**
	 * Sets the yCoordinate.
	 * @param yCoordinate The yCoordinate to set
	 */
	void setYCoordinate(String yCoordinate);
	
	/**
	 * Sets the viewbox.
	 * @param viewBox The viewBox to set
	 */
	void setViewbox(String viewbox);

	/**
	 * Sets the preserveAspectRatio.
	 * @param preserveAspectRatio The preserveAspectRatio to set
	 */
	void setPreserveAspectRatio(String preserveAspectRatio);

}
