/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGFeGaussianBlur.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGFeGaussianBlur.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <code>ISVGFeGaussianBlur</code> interface defines accessors for attributes which are 
 * common to Scalable Vector Graphics (SVG) "feGaussianBlur" elements. Also provides for
 * generating the implementation element.
 * 
 * $Revision: 1.1 $
 */
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface ISVGFeGaussianBlur {
	/**
	 * Generates and returns the implementation of the SVG element.
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element
	 * @throws DOMException if the tag name contains an illegal character.	
	 */
	Element doImplementation(Document svgDocument) throws DOMException;
	/**
	 * Returns the Standard Deviation.
	 * @return String
	 */
	public abstract String getStdDeviation();
	/**
	 * Sets the Standard Deviation.
	 * @param stdDeviation The Standard Deviation to set
	 */
	public abstract void setStdDeviation(String stdDeviation);

	/**
	 * Returns the in.
	 * @return String
	 */
	public abstract String getIn();

	/**
	 * Returns the result.
	 * @return String
	 */
	public abstract String getResult();

	/**
	 * Sets the in.
	 * @param in The in to set
	 */
	public abstract void setIn(String in);

	/**
	 * Sets the result.
	 * @param result The result to set
	 */
	public abstract void setResult(String result);
}