/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGFilterBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGFilterBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <code>ISVGFilterBase</code> interface defines accessors for attributes which are 
 * common to Scalable Vector Graphics (SVG) "filter" elements. Also provides for
 * generating the implementation element.
 * 
 * $Revision: 1.1 $
 */
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface ISVGFilterBase {
	/**
	 * Generates and returns the implementation of the SVG element.
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element
	 * @throws DOMException if the tag name contains an illegal character.	
	 */
	Element doImplementation(Document svgDocument) throws DOMException;
		
	/**
	 * Returns the height.
	 * @return String
	 */
	public abstract String getHeight();
	/**
	 * Returns the width.
	 * @return String
	 */
	public abstract String getWidth();
	/**
	 * Returns the x.
	 * @return String
	 */
	public abstract String getX();
	/**
	 * Returns the y.
	 * @return String
	 */
	public abstract String getY();
	/**
	 * Sets the height.
	 * @param height The height to set
	 */
	public abstract void setHeight(String height);
	/**
	 * Sets the width.
	 * @param width The width to set
	 */
	public abstract void setWidth(String width);
	/**
	 * Sets the x.
	 * @param x The x to set
	 */
	public abstract void setX(String x);
	/**
	 * Sets the y.
	 * @param y The y to set
	 */
	public abstract void setY(String y);
}