/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGGraphicBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGGraphicBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <code>ISVGGraphicBase</code> interface defines accessors for attributes which are common to 
 * a subset of the specified Scalable Vector Graphics (SVG) elements; in particular, those
 * which display as graphics. 
 * 

 * $Revision: 1.1 $
 */
public interface ISVGGraphicBase {
	
	/**
	 * Returns the transformation.
	 * @return String
	 */
	String getTransformation();
		
	/**
	 * Returns the fill color.
	 * @return String
	 */
	String getFill();
	
	/**
	 * Returns the stroke color.
	 * @return String
	 */
	String getStroke();
		
	/**
	 * Returns the x-coordinate.
	 * @return String
	 */
	String getXCoordinate();

	/**
	 * Returns the y-coordinate.
	 * @return String
	 */
	String getYCoordinate();
				
	/**
	 * Sets the transformation.
	 * @param transformation The transformation to set.
	 */
	void setTransformation(String tTransformation);
	
	/**
	 * Sets the fill color.
	 * @param fill The fill to set.
	 */
	void setFill(String fill);
		
	/**
	 * Sets the stroke color.
	 * @param stroke The stroke to set
	 */
	void setStroke(String stroke);

	/**
	 * Sets the xCoordinate.
	 * @param xCoordinate The xCoordinate to set
	 */
	void setXCoordinate(String xCoordinate);

	/**
	 * Sets the yCoordinate.
	 * @param yCoordinate The yCoordinate to set
	 */
	void setYCoordinate(String yCoordinate);

}
