/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGLineBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGLineBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>ISVGLineBase</code> interface defines accessors for attributes which are 
 * common to Scalable Vector Graphics (SVG) "Line" elements. Also provides for
 * generating the implementation element.
 * 

 * $Revision: 1.1 $
 */

public interface ISVGLineBase {

	/**
	 * Generates and returns the implementation of the SVG element.
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element
	 * @throws DOMException if the tag name contains an illegal character.	
	 */
	Element doImplementation(Document svgDocument) throws DOMException;	
	
	/**
	 * @return
	 */
	public String getX1();

	/**
	 * @return
	 */
	public String getX2();

	/**
	 * @return
	 */
	public String getY1();

	/**
	 * @return
	 */
	public String getY2();

	/**
	 * @param string
	 */
	public void setX1(String string);

	/**
	 * @param string
	 */
	public void setX2(String string);

	/**
	 * @param string
	 */
	public void setY1(String string);

	/**
	 * @param string
	 */
	public void setY2(String string);

}
