/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGLinearGradientBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGLinearGradientBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

 
/**
 * <code>ISVGLinearGradientBase</code> interface defines accessors for attributes which are 
 * common to Scalable Vector Graphics (SVG) "linearGradient" elements. Also provides for
 * generating the implementation element.
 */
public interface ISVGLinearGradientBase {

	/**
	 * Generates and returns the implementation of the SVG element.
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element
	 * @throws DOMException if the tag name contains an illegal character.	
	 */
	Element doImplementation(Document svgDocument) throws DOMException;

	/**
	 * Returns the spreadMethod.
	 * @return String
	 */
	public String getSpreadMethod();

	/**
	 * Returns the x1.
	 * @return String
	 */
	public String getX1();
	/**
	 * Returns the x2.
	 * @return String
	 */
	public String getX2();

	/**
	 * Returns the y1.
	 * @return String
	 */
	public String getY1();

	/**
	 * Returns the y2.
	 * @return String
	 */
	public String getY2();

	/**
	 * Sets the spreadMethod.
	 * @param spreadMethod The spreadMethod to set
	 */
	public void setSpreadMethod(String spreadMethod);

	/**
	 * Sets the x1.
	 * @param x1 The x1 to set
	 */
	public void setX1(String x1);

	/**
	 * Sets the x2.
	 * @param x2 The x2 to set
	 */
	public void setX2(String x2);
	/**
	 * Sets the y1.
	 * @param y1 The y1 to set
	 */
	public void setY1(String y1);

	/**
	 * Sets the y2.
	 * @param y2 The y2 to set
	 */
	public void setY2(String y2);
	
	/**
	 * Returns the gradientUnits.
	 * @return String
	 */
	public String getGradientUnits();

	/**
	 * Sets the gradientUnits.
	 * @param gradientUnits The gradientUnits to set
	 */
	public void setGradientUnits(String gradientUnits);

}
