/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGSetBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGSetBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

 
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>ISVGSetBase</code> interface defines accessors for attributes which are 
 * common to Scalable Vector Graphics (SVG) "set" elements. Also provides for
 * generating the implementation element.
 * 

 * $Revision: 1.1 $
 */
public interface ISVGSetBase {	
	
	/**
	 * Generates and returns the implementation of the SVG element.
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element
	 * @throws DOMException if the tag name contains an illegal character.	
	 */	
	Element doImplementation(Document svgDocument) throws DOMException;
	
	/**
	 * Returns the attributeName.
	 * @return String
	 */
	String getAttributeName();

	/**
	 * Returns the attributeType.
	 * @return String
	 */
	String getAttributeType();

	/**
	 * Returns the begain.
	 * @return String
	 */
	String getBegain();

	/**
	 * Returns the dur.
	 * @return String
	 */
	String getDur();

	/**
	 * Returns the end.
	 * @return String
	 */
	String getEnd();

	/**
	 * Returns the fill.
	 * @return String
	 */
	String getFill();

	/**
	 * Returns the from.
	 * @return String
	 */
	String getFrom();

	/**
	 * Returns the to.
	 * @return String
	 */
	String getTo();

	/**
	 * Sets the attributeName.
	 * @param attributeName The attributeName to set
	 */
	void setAttributeName(String attributeName);

	/**
	 * Sets the attributeType.
	 * @param attributeType The attributeType to set
	 */
	void setAttributeType(String attributeType);

	/**
	 * Sets the begain.
	 * @param begain The begain to set
	 */
	void setBegain(String begain);

	/**
	 * Sets the dur.
	 * @param dur The dur to set
	 */
	void setDur(String dur);

	/**
	 * Sets the end.
	 * @param end The end to set
	 */
	void setEnd(String end);

	/**
	 * Sets the fill.
	 * @param fill The fill to set
	 */
	void setFill(String fill);

	/**
	 * Sets the from.
	 * @param from The from to set
	 */
	void setFrom(String from);

	/**
	 * Sets the to.
	 * @param to The to to set
	 */
	void setTo(String to);

}
