/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGSymbolBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGSymbolBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * <code>ISVGSymbolBase</code> interface defines accessors for attributes which are 
 * common to Scalable Vector Graphics (SVG) "symbol" elements. Also provides for
 * generating the implementation element.
 * 

 * $Revision: 1.1 $
 */
public interface ISVGSymbolBase {
	
	/**
	 * Generates and returns the implementation of the SVG element.
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element
	 * @throws DOMException if the tag name contains an illegal character.	
	 */
	Element doImplementation(Document svgDocument) throws DOMException, NullPointerException;
	
	/**
	 * Returns the preserveAspectRatio.
	 * @return String
	 */
	String getPreserveAspectRatio();
	
	/**
	 * Returns the viewbox.
	 * @return String
	 */
	String getViewbox();

	/**
	 * Sets the preserveAspectRatio.
	 * @param newPreserveAspectRatio The newPreserveAspectRatio to set.
	 */
	void setPreserveAspectRatio(String newPreserveAspectRatio);

	/**
	 * Sets the viewbox.
	 * @param newViewbox The newViewbox to set.
	 */
	void setViewbox(String newViewbox);

}
