/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGTextBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISVGTextBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>ISVGTextBase</code> interface defines accessors for attributes which are 
 * common to Scalable Vector Graphics (SVG) "text" elements. Also provides for
 * generating the implementation element.
 * 

 * $Revision: 1.1 $
 */
public interface ISVGTextBase {

	/**
	 * Generates and returns the implementation of the SVG element.
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element
	 * @throws DOMException if the tag name contains an illegal character.	
	 */
	Element doImplementation(Document svgDocument) throws DOMException, NullPointerException;
	
	/**
	 * Returns the text.
	 * @return String
	 */
	String getText();
	
	/**
	 * Returns the fontFamily.
	 * @return String
	 */
	String getFontFamily();

	/**
	 * Returns the fontSize.
	 * @return String
	 */
	String getFontSize();

	/**
	 * Returns the fontWeight.
	 * @return String
	 */
	String getFontWeight();
	
	/**
	 * Returns the fontStyle.
	 * @return String
	 */
	String getFontStyle();

	/**
	 * Returns the textDecoration.
	 * @return String
	 */
	String getTextDecoration();

	/**
	 * Returns the wordSpacing.
	 * @return String
	 */
	String getWordSpacing();
	
	/**
	 * Returns the letterSpacing.
	 * @return String
	 */
	String getLetterSpacing();
	
	/**
	 * Returns the textAnchor.
	 * @return String
	 */
	String getTextAnchor();

	/**
	 * Sets the fontFamily.
	 * @param fontFamily The fontFamily to set
	 */
	void setFontFamily(String fontFamily);

	/**
	 * Sets the fontSize.
	 * @param fontSize The fontSize to set
	 */
	void setFontSize(String fontSize);

	/**
	 * Sets the fontStyle.
	 * @param fontStyle The fontStyle to set
	 */
	void setFontStyle(String fontStyle);

	/**
	 * Sets the fontWeight.
	 * @param fontWeight The fontWeight to set
	 */
	void setFontWeight(String fontWeight);

	/**
	 * Sets the letterSpacing.
	 * @param letterSpacing The letterSpacing to set
	 */
	void setLetterSpacing(String letterSpacing);

	/**
	 * Sets the text.
	 * @param text The text to set
	 */
	void setText(String text);

	/**
	 * Sets the textAnchor.
	 * @param textAnchor The textAnchor to set
	 */
	void setTextAnchor(String textAnchor);

	/**
	 * Sets the textDecoration.
	 * @param textDecoration The textDecoration to set
	 */
	void setTextDecoration(String textDecoration);

	/**
	 * Sets the wordSpacing.
	 * @param wordSpacing The wordSpacing to set
	 */
	void setWordSpacing(String wordSpacing);

}
