/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGBase</code> is an abstract base class for classes which implement
 * Scalable Vector Graphics (SVG) graphics as Document Object Model (DOM) objects.
 * Applicable to SVG graphics elements which support the common set of SVG attributes 
 * implemented here.
 *
 * $Revision: 1.1 $
 */
abstract public class SVGBase implements ISVGBase, Serializable {		
	private String tagName;
	private String identifier;	
	private String style;
	private String styleClass;	
	private String visibility;
		
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG element
	 * specified in <code>tagName</code> and sets any non-<code>null</code> attributes. 
	 * Overriding classes should return <code>null</code> if any required attributes 
	 * for the particular SVG element are missing. 
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element or <code>null</code> if tagName is <code>null</code>.	
	 * @throws DOMExcepton if the tag name contains an illegal character.
	 */
	protected Element doImplementation(Document svgDocument) throws DOMException {
		Element implementation;
		
		// nothing to do
		if (tagName == null || svgDocument == null) {
			return null;
		}					
		
		// create the element using the tag name
		implementation = svgDocument.createElement(tagName);
				
		// set any non-null attributes we know about	
		if (implementation != null) {						
			if (identifier != null) {	
				implementation.setAttribute("id", identifier);
			}
					
			if (style != null) {
				implementation.setAttribute("style", style);
			}	
			
			if (styleClass != null) {
				implementation.setAttribute("class", styleClass);
			}

			if (visibility != null) {
				implementation.setAttribute("visibility", visibility);
			}
		}			
		return implementation;
	}		
		
	/**
	 * Returns the tag name for the element.
	 * @return String
	 */
	protected String getTagName() {
		return tagName;
	}
		
	/**
	 * @see ISVGBase#getIdentifier()
	 */
	public String getIdentifier() {
		return identifier;
	}
	
	/**
	 * @see ISVGBase#getStyle()
	 */
	public String getStyle() {
		return style;
	}
	
	/**
	 * @see ISVGBase#getStyleClass()
	 */
	public String getStyleClass() {
		return styleClass;
	}
		
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.ISVGBase#getVisibility()
	 */
	public String getVisibility() {
		return visibility;
	}

	/**
	 * Sets the tag name for the element.
	 * @param tagName The tagName to set
	 */
	protected void setTagName(String tagName) {
		this.tagName = tagName;
	}
		
	/**
	 * @see ISVGBase#setIdentifier()
	 */
	public void setIdentifier(String identifier) {
		this.identifier = identifier;			
	}
	
	/**
	 * @see ISVGBase#setStyle()
	 */
	public void setStyle(String style) {
		this.style = style;
	}

	/**
	 * @see ISVGBase#setStyleClass()
	 */
	public void setStyleClass(String styleClass) {
		this.styleClass = styleClass;
	}
		
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.ISVGBase#setVisibility(java.lang.String)
	 */
	public void setVisibility(String visibility) {
		this.visibility = visibility;
	}

	/**
	 * @see ISVGBase#getImplementation()
	 */
	abstract public Element getImplementation();	
	
}
