/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGCircle.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGCircle.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGCircle</code> is an implementation class for Scalable Vector Graphics (SVG) 
 * "circle" elements. 
 *
 * $Revision: 1.2 $
 */
public class SVGCircle extends SVGCircleBase implements Serializable {
	private Element implementation;
	static final long serialVersionUID = 916989768677260483L;	
	/**
	 * Sole constructor.
	 */
	public SVGCircle() {
		super();
		setTagName("circle");
	}	
		
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "circle" element
	 * 	
	 * @param Document the target SVG Document
	 * @param String the radius
	 * @return Element the implementation 
	 * @throws NullPointerException ???
	 */
	public Element doImplementation(Document svgDocument, String radius) throws NullPointerException {	
		setRadius(radius);		
		
		try {
			implementation = super.doImplementation(svgDocument);			
		} catch (DOMException e) {}				
		
		return implementation;	
	}
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "circle" element
	 * 	
	 * @param Document the target SVG Document
	 * @param String the radius
	 * @param String the center x-coordinate
	 * @param String the center y-coordinate
	 * @return Element the implementation 
	 * @throws NullPointerException ???
	 */
	public Element doImplementation(Document svgDocument, String radius, String cx, String cy) throws NullPointerException {	
		setRadius(radius);	
		setCx(cx);
		setCy(cy);	
				
		try {
			implementation = super.doImplementation(svgDocument);			
		} catch (DOMException e) {}				
		
		return implementation;	
	}
				
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}	
}

