/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGCircleBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGCircleBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGCircleBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "circles" elements.
 *
 * $Revision: 1.1 $
 */
abstract public class SVGCircleBase extends SVGGraphicBase implements ISVGCircleBase, Serializable {		
	private String cx;
	private String cy;	
	private String radius;	
	
	/**
	 * @see ISVGCircleBase#doImplementation()
	 */
	public Element doImplementation(Document svgDocument) throws DOMException {
		Element circleElement;
		
		// nothing to do
		if (radius == null){
			return null;
		}
			
		// get our element	
		circleElement = super.doImplementation(svgDocument);

		//set any non-null attributes we know about
		if (circleElement != null) {				
			circleElement.setAttribute("r", radius);
			// todo - what to do if they set the x,y from SVGGraphicBase?
			if (cx != null) {			
				circleElement.setAttribute("cx", cx);
			}	
				
			if (cy != null) {			
				circleElement.setAttribute("cy", cy);
			}
		}		
		return circleElement;
	}		
	
	
	/**
	 * @see ISVGCircleBase#getCx()
	 */
	public String getCx() {
		return cx;
	}

	/**
	 * @see ISVGCircleBase#getCy()
	 */
	public String getCy() {
		return cy;
	}

	/**
	 * @see ISVGCircleBase#getRadius()
	 */
	public String getRadius() {
		return radius;
	}

	/**
	 * @see ISVGCircleBase#setCx()
	 */
	public void setCx(String cx) {
		this.cx = cx;
	}

	/**
	 * @see ISVGCircleBase#setCy()
	 */
	public void setCy(String cy) {
		this.cy = cy;
	}

	/**
	 * @see ISVGCircleBase#setRadius()
	 */
	public void setRadius(String radius) {
		this.radius = radius;
	}

}
