/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGClipPath.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGClipPath.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGClipPath</code> is an implementation class for Scalable Vector Graphics (SVG) 
 * "clipPath" elements. 
 *
 * $Revision: 1.2 $
 */
public class SVGClipPath extends SVGClipPathBase implements Serializable {
	Element implementation;
	static final long serialVersionUID = 6336692987331228134L;
	/**
	 * Sole constructor.
	 */
	public SVGClipPath() {
		super();
		setTagName("clipPath");
	}

	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "clipPath" element 
	 * 
	 * @param svgDocument the target SVG document
	 * @param clipPathUnits 
	 * @return the implementation
	 * @throws NullPointerException
	 */
	public Element doImplementation(Document svgDocument, String clipPathUnits) throws NullPointerException {	
		setClipPathUnits(clipPathUnits);
		
		try {		
			implementation = super.doImplementation(svgDocument);
		} catch (DOMException e) {}
		
		return implementation;
	}
	
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.ISVGBase#getImplementation()
	 */
	public Element getImplementation() {
		return implementation;
	}

}
