/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGClipPathBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGClipPathBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGClipPathBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "clipPath" elements.
 *
 * $Revision: 1.1 $
 */
public abstract class SVGClipPathBase extends SVGContainerBase implements ISVGClipPathBase {

	private String clipPathUnits;
	
	/**
	 * @see ISVGRectangleBase#doImplementation()
	 */
	public Element doImplementation(Document svgDocument) throws DOMException {
		Element clipPathElement;
		
		// get our element
		clipPathElement = super.doImplementation(svgDocument);			
		
		// set any non-null attributes we know about
		if (clipPathUnits != null) {				
			clipPathElement.setAttribute("clipPathUnits", clipPathUnits);
		}			
		return clipPathElement;
	}		

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.ISVGClipPathBase#getClipPathUnits()
	 */
	public String getClipPathUnits() {
		return clipPathUnits;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.ISVGClipPathBase#setClipPathUnits(java.lang.String)
	 */
	public void setClipPathUnits(String clipPathUnits) {
		this.clipPathUnits = clipPathUnits;
	}

}
