/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGContainerBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGContainerBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGContainerBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) container elements. Applicable to SVG containers 
 * which support the common set of SVG attributes implemented here.
 *
 * $Revision: 1.1 $
 */
abstract public class SVGContainerBase extends SVGBase implements ISVGContainerBase, Serializable {
	private SVGBase [] children;
	private String title;
	private String desc;
	
	/**
	 * Calls the superclass to create the SVG container element and then sets any non-<code>null</code> base 
	 * attributes. Calls the <code>doImplementation(Document)</code> method on all children - any 
	 * children returning <code>null</code> will not have elements added to the container.
	 * 	
	 * @param Document the target SVG Document
	 * @return Element the container implementation or <code>null</code> if the element was not created.
	 * @throws DOMException if the tag name contains an illegal character.	
	 * @throws NullPointerException if any child elements are <code>null</code>.
	 */
	protected Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {			
		// get our element
		Element containerElement = super.doImplementation(svgDocument);
		Element childElement;
		
		// add our container elements and set any non-null attributes we know about
		if (containerElement != null) {					
			if (children != null) {	
				for (int i = 0; i < children.length; i++) {
					if (children[i] != null) {
						childElement = children[i].doImplementation(svgDocument);
						if (childElement != null) {
							containerElement.appendChild(childElement);
						}
					}
				}			
			}
			
			if (title != null) {
				SVGTitle svgTitle = new SVGTitle();			
				containerElement.appendChild(svgTitle.doImplementation(svgDocument, title));			
			}
			
			if (desc != null) {
				SVGDesc svgDescription = new SVGDesc();			
				containerElement.appendChild(svgDescription.doImplementation(svgDocument, desc));					
			}
		}												
		return containerElement;
	}		
			
	/**
	 * @see ISVGContainerBase#getChildren()
	 */
	public SVGBase[] getChildren() {
		return children;
	}

	/**
	 * @see ISVGContainerBase#getDesc()
	 */
	public String getDesc() {
		return desc;
	}

	/**
	 * @see ISVGContainerBase#getTitle()
	 */
	public String getTitle() {
		return title;
	}
	
	/**
	 * @see ISVGContainerBase#setChildren()
	 */
	public void setChildren(SVGBase [] children) {
		this.children = children;
	}
	
	/**
	 * @see ISVGContainerBase#setDesc()
	 */
	public void setDesc(String desc) {
		this.desc = desc;
	}

	/**
	 * @see ISVGContainerBase#setTitle()
	 */
	public void setTitle(String title) {
		this.title = title;
	}

}
