/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDefinition.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDefinition.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.Iterator;
import java.util.Vector;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * <code>SVGDefinition</code> is an is an implementation class for Scalable Vector Graphics (SVG) 
 * "defs" elements.  
 * 
 * $Revision: 1.2 $
 */
public class SVGDefinition extends SVGContainerBase {
	private Element implementation;
	static final long serialVersionUID = 2109233117245167026L;	
	private Vector definitions = null;

	/**
	 * Sole constructor.
	 */
	public SVGDefinition() {
		super();
		setTagName("defs");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.ISVGBase#getImplementation()
	 */
	public Element getImplementation() {
		return implementation;
	}
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "defs" element 
	 * 	
	 * @param Document the target SVG Document	
	 * @return Element the implementation.
	 */
	public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {		
		implementation = super.doImplementation(svgDocument);
		if (definitions != null) {
			for (Iterator i=definitions.iterator(); i.hasNext(); ) {
				Node node = (Node) i.next();
				Node newNodeToMove = svgDocument.importNode(node, true);
				implementation.appendChild(newNodeToMove);
			}
		}
		return(implementation);		
	}
	
	/**
	 * Add a vector of definition in the form of XML elements
	 * @param definitions
	 */
	public void setDefinitions(Vector definitions) {
		this.definitions = definitions;
	}
}
