/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDocumentFragmentBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGDocumentFragmentBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGDocumentFragmentBase</code> is an abstract base class for classes which
 * generate Scalable Vector Graphics (SVG) document fragments ("svg" elements). 
 *
 * $Revision: 1.1 $
 */
abstract public class SVGDocumentFragmentBase extends SVGContainerBase implements ISVGDocumentFragmentBase, Serializable {		
	private String width;
	private String height;
	private String xCoordinate;
	private String yCoordinate;
	private String viewbox;
	private String preserveAspectRatio;
	
	/**
	 * Calls the superclass to create the SVG container element and then sets 
	 * any non-<code>null</code> base attributes.
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element or <code>null</code> if the element was not created. 
	 * @throws DOMException if the tag name contains an illegal character.	
	 * @throws NullPointerException if any specified contained elements are <code>null</code>.
	 */
	protected Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {
		// get our element
		Element svgElement = super.doImplementation(svgDocument);			
		
		// set any non-null attributes we know about
		if (svgElement != null) {		
			if (width != null) {
				svgElement.setAttribute("width", width);
			}
			
			if (height != null) {
				svgElement.setAttribute("height", height);
			}
			
			if (xCoordinate != null) {
				svgElement.setAttribute("x", xCoordinate);
			}
			
			if (yCoordinate != null) {
				svgElement.setAttribute("y", yCoordinate);
			}
			
			if (viewbox != null) {
				svgElement.setAttribute("viewbox", viewbox);
			}
			
			if (preserveAspectRatio != null) {
				svgElement.setAttribute("preserveAspectRatio", preserveAspectRatio);
			}		
		}							
		return svgElement;
	}		

	/**
	 * @see ISVGDocumentFragmentBase#getWidth()
	 */
	public String getWidth() {
		return width;
	}
		
	/**
	 * @see ISVGDocumentFragmentBase#getHeight()
	 */
	public String getHeight() {
		return height;
	}
	
	/**
	 * @see ISVGDocumentFragmentBase#getXCoordinate()
	 */
	public String getXCoordinate() {
		return xCoordinate;
	}

	/**
	 * @see ISVGDocumentFragmentBase#getYCoordinate()
	 */
	public String getYCoordinate() {
		return yCoordinate;
	}
	
	/**
	 * @see ISVGDocumentFragmentBase#getViewbox()
	 */
	public String getViewbox() {
		return viewbox;
	}

	/**
	 * @see ISVGDocumentFragmentBase#getPreserveAspectRatio()
	 */
	public String getPreserveAspectRatio() {
		return preserveAspectRatio;
	}

	/**
	 * @see ISVGDocumentFragmentBase#setWidth()
	 */
	public void setWidth(String width) {
		this.width = width;
	}

	/**
	 * @see ISVGDocumentFragmentBase#setHeight()
	 */
	public void setHeight(String height) {
		this.height = height;
	}
	
	/**
	 * @see ISVGDocumentFragmentBase#setXCoordinate()
	 */
	public void setXCoordinate(String xCoordinate) {
		this.xCoordinate = xCoordinate;
	}

	/**
	 * @see ISVGDocumentFragmentBase#setYCoordinate()
	 */
	public void setYCoordinate(String yCoordinate) {
		this.yCoordinate = yCoordinate;
	}
	
	/**
	 * @see ISVGDocumentFragmentBase#setViewbox()
	 */
	public void setViewbox(String viewbox) {
		this.viewbox = viewbox;
	}

	/**
	 * @see ISVGDocumentFragmentBase#setPreserveAspectRatio()
	 */
	public void setPreserveAspectRatio(String preserveAspectRatio) {
		this.preserveAspectRatio = preserveAspectRatio;
	}
	
}
