/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFeComponentTransferBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFeComponentTransferBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.w3c.dom.Document;
import org.w3c.dom.Element;

import java.io.Serializable;

/**
 * <code>SVGFeComponentTransferBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "feComponentTransferBase" elements.
 */
abstract public class SVGFeComponentTransferBase extends SVGContainerBase
    implements ISVGFeComponentTransfer, Serializable {
    /**
     * Calls the superclass to create the SVG container element and then sets any non-<code>null</code> base
     * attributes. Calls the <code>doImplementation(Document)</code> method on all children - any
     * children returning <code>null</code> will not have elements added to the container.
     *
     * @param Document the target SVG Document
     * @return Element the container implementation or <code>null</code> if the element was not created.
     * @throws DOMException if the tag name contains an illegal character.
     * @throws NullPointerException if any child elements are <code>null</code>.
     */
    public Element doImplementation(Document svgDocument) {
        Element gaussianBlurElement;

        // get our element	
        return super.doImplementation(svgDocument);
    }
}
