/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFeFunc.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFeFunc.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGFeFunc</code> is a implementation class for Scalable Vector Graphics (SVG) 
 * "feFunc" elements. 
 */
public class SVGFeFunc extends SVGFeFuncBase {
    private Element implementation;
    static final long serialVersionUID = -4379126725773679293L;
    /**
     * Sole constructor.
     */
    public SVGFeFunc(String type) {
        super();
        setTagName("feFunc" + type);
    }

    /**
     * Creates the Document Object Model (DOM) implementation of the SVG "feGaussianBlur" element
     *
     * @param Document the target SVG Document
     * @param String the type
     * @param String the intercept
     * @param String the slope
     * @return Element the implementation
     * @throws NullPointerException ???
     */
    public Element doImplementation(Document svgDocument, String type,
        String intercept, String slope) throws NullPointerException {
        setType(type);
        setIntercept(intercept);
        setSlope(slope);

        try {
            implementation = super.doImplementation(svgDocument);
        } catch (DOMException e) {
        }

        return implementation;
    }

    /**
     * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation()
     */
    public Element getImplementation() {
        return implementation;
    }
}
