/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFeFuncBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFeFuncBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.w3c.dom.Document;
import org.w3c.dom.Element;

import java.io.Serializable;

/**
 * <code>SVGFeFuncBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "feFuncBase" elements.
 */
abstract public class SVGFeFuncBase extends SVGGraphicBase implements ISVGFeFunc,
    Serializable {
    private String type;
    private String intercept;
    private String slope;

    /**
     * Calls the superclass to create the SVG container element and then sets any non-<code>null</code> base
     * attributes. Calls the <code>doImplementation(Document)</code> method on all children - any
     * children returning <code>null</code> will not have elements added to the container.
     *
     * @param Document the target SVG Document
     * @return Element the container implementation or <code>null</code> if the element was not created.
     * @throws DOMException if the tag name contains an illegal character.
     * @throws NullPointerException if any child elements are <code>null</code>.
     */
    public Element doImplementation(Document svgDocument) {
        Element gaussianBlurElement;

        // get our element	
        gaussianBlurElement = super.doImplementation(svgDocument);

        //set any non-null attributes we know about
        if (gaussianBlurElement != null) {
            if (type != null) {
                gaussianBlurElement.setAttribute("type", type);
            }

            if (intercept != null) {
                gaussianBlurElement.setAttribute("intercept", intercept);
            }

            if (slope != null) {
                gaussianBlurElement.setAttribute("slope", slope);
            }
        }

        return gaussianBlurElement;
    }

    /**
     * Returns the Type.
     * @return String
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the Type.
     * @param type The Type to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * Returns the intercept.
     * @return String
     */
    public String getIntercept() {
        return intercept;
    }

    /**
     * Returns the slope.
     * @return String
     */
    public String getSlope() {
        return slope;
    }

    /**
     * Sets the intercept.
     * @param intercept The intercept to set
     */
    public void setIntercept(String intercept) {
        this.intercept = intercept;
    }

    /**
     * Sets the slope.
     * @param slope The slope to set
     */
    public void setSlope(String slope) {
        this.slope = slope;
    }
}
