/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFeGaussianBlurBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFeGaussianBlurBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGFeGaussianBlurBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "feGaussianBlur" elements.
 *
 * $Revision: 1.1 $
 */
abstract public class SVGFeGaussianBlurBase extends SVGGraphicBase implements ISVGFeGaussianBlur, Serializable {
	
	private String stdDeviation;
	private String in;
	private String result;
	
	/**
	 * Calls the superclass to create the SVG container element and then sets any non-<code>null</code> base 
	 * attributes. Calls the <code>doImplementation(Document)</code> method on all children - any 
	 * children returning <code>null</code> will not have elements added to the container.
	 * 	
	 * @param Document the target SVG Document
	 * @return Element the container implementation or <code>null</code> if the element was not created.
	 * @throws DOMException if the tag name contains an illegal character.	
	 * @throws NullPointerException if any child elements are <code>null</code>.
	 */
	public Element doImplementation(Document svgDocument) {
		Element gaussianBlurElement;
					
		// get our element	
		gaussianBlurElement = super.doImplementation(svgDocument);

		//set any non-null attributes we know about
		if (gaussianBlurElement != null) {				
				
			if (stdDeviation != null) {			
				gaussianBlurElement.setAttribute("stdDeviation", stdDeviation);
			}
			if (in != null) {			
				gaussianBlurElement.setAttribute("in", in);
			}
			if (result != null) {			
				gaussianBlurElement.setAttribute("result", result);
			}
		}		
		return gaussianBlurElement;	
	}

	/**
	 * Returns the Standard Deviation.
	 * @return String
	 */
	public String getStdDeviation() {
		return stdDeviation;
	}

	/**
	 * Sets the Standard Deviation.
	 * @param stdDeviation The Standard Deviation to set
	 */
	public void setStdDeviation(String stdDeviation) {
		this.stdDeviation = stdDeviation;
	}

	/**
	 * Returns the in.
	 * @return String
	 */
	public String getIn() {
		return in;
	}

	/**
	 * Returns the result.
	 * @return String
	 */
	public String getResult() {
		return result;
	}

	/**
	 * Sets the in.
	 * @param in The in to set
	 */
	public void setIn(String in) {
		this.in = in;
	}

	/**
	 * Sets the result.
	 * @param result The result to set
	 */
	public void setResult(String result) {
		this.result = result;
	}

}
