/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFilter.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFilter.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGFilter</code> is a implementation class for Scalable Vector Graphics (SVG) 
 * "filter" elements. 
 * 
 * $Revision: 1.2 $
 */
public class SVGFilter extends SVGFilterBase {
	
	private Element implementation;
	static final long serialVersionUID = 2335372018584633862L;	
	/**
	 * Sole constructor.
	 */
	public SVGFilter() {
		super();
		setTagName("filter");
	}	
		
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "filter" element
	 * 	
	 * @param Document the target SVG Document
	 * @param String the height of the canvas to apply the filter
	 * @param String the width of the canvas to apply the filter
	 * @param String the x-coordinate of the canvas to apply the filter
	 * @param String the y-coordinate
	 * @return Element the implementation 
	 * @throws NullPointerException ???
	 */
	public Element doImplementation(Document svgDocument, String height, String width, String x, String y) throws NullPointerException {	
		setHeight(height);
		setWidth(width);	
		setX(x);
		setY(y);	
				
		try {
			implementation = super.doImplementation(svgDocument);			
		} catch (DOMException e) {}				
		
		return implementation;	
	}
				
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}	

}
