/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFilterBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGFilterBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <code>SVGFilterBase</code> is an abstract base class for classes which generate 
 * Scalable Vector Graphics (SVG) "filter" elements.
 *
 * $Revision: 1.1 $
 */
abstract public class SVGFilterBase extends SVGContainerBase implements ISVGFilterBase, Serializable {
	private String x;
	private String y;
	private String width;
	private String height;

	/**
	 * Calls the superclass to create the SVG container element and then sets any non-<code>null</code> base 
	 * attributes. Calls the <code>doImplementation(Document)</code> method on all children - any 
	 * children returning <code>null</code> will not have elements added to the container.
	 * 	
	 * @param Document the target SVG Document
	 * @return Element the container implementation or <code>null</code> if the element was not created.
	 * @throws DOMException if the tag name contains an illegal character.	
	 * @throws NullPointerException if any child elements are <code>null</code>.
	 */
	public Element doImplementation(Document svgDocument) {
		Element gaussianBlurElement;
					
		// get our element	
		gaussianBlurElement = super.doImplementation(svgDocument);

		//set any non-null attributes we know about
		if (gaussianBlurElement != null) {				
				
			if (height != null) {			
				gaussianBlurElement.setAttribute("height", height);
			}
			if (width != null) {			
				gaussianBlurElement.setAttribute("width", width);
			}
			if (x != null) {			
				gaussianBlurElement.setAttribute("x", x);
			}
			if (y != null) {			
				gaussianBlurElement.setAttribute("y", y);
			}
		}		
		return gaussianBlurElement;	
	}

	/**
	 * Returns the height.
	 * @return String
	 */
	public String getHeight() {
		return height;
	}

	/**
	 * Returns the width.
	 * @return String
	 */
	public String getWidth() {
		return width;
	}

	/**
	 * Returns the x.
	 * @return String
	 */
	public String getX() {
		return x;
	}

	/**
	 * Returns the y.
	 * @return String
	 */
	public String getY() {
		return y;
	}

	/**
	 * Sets the height.
	 * @param height The height to set
	 */
	public void setHeight(String height) {
		this.height = height;
	}

	/**
	 * Sets the width.
	 * @param width The width to set
	 */
	public void setWidth(String width) {
		this.width = width;
	}

	/**
	 * Sets the x.
	 * @param x The x to set
	 */
	public void setX(String x) {
		this.x = x;
	}

	/**
	 * Sets the y.
	 * @param y The y to set
	 */
	public void setY(String y) {
		this.y = y;
	}

}
