/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGGraphicBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGGraphicBase.java,v 1.1 2005/03/30 08:26:38 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGGraphicBase</code> is an abstract base class for classes which implement
 * Scalable Vector Graphics (SVG) graphics as Document Object Model (DOM) objects.
 * Applicable to SVG graphic objects which support the common set of SVG attributes 
 * implemented here.
 *
 * $Revision: 1.1 $
 */
abstract public class SVGGraphicBase extends SVGBase implements ISVGGraphicBase, Serializable {	
	private String transformation;			
	private String fill;
	private String stroke;
	private String xCoordinate;
	private String yCoordinate;
	private String filter;	
	
	
	/**
	 * Calls the superclass to create the element then sets any non-<code>null</code> attributes. 
	 * Overriding classes should return <code>null</code> if any required attributes 
	 * for the particular SVG element are missing. 
	 * 
	 * @param Document the target SVG document.	
	 * @return Element the implementation element.
	 * @throws DOMException if the tag name contains an illegal character.	
	 */
	protected Element doImplementation(Document svgDocument) throws DOMException {
		// get our element
		Element baseElement = super.doImplementation(svgDocument);				
		
		// set any non-null attributes we know about
		if (baseElement != null) {	
							
			if (transformation != null) {	
				baseElement.setAttribute("transform", transformation);
			}
					
			if (fill != null) {
				baseElement.setAttribute("fill", fill);
			}	
			
			if ((stroke != null)  && (stroke.length() >0)){
				baseElement.setAttribute("stroke", stroke);
			}	
			
			if (xCoordinate != null) {
				baseElement.setAttribute("x", xCoordinate);
			}	
			
			if (yCoordinate != null) {
				baseElement.setAttribute("y", yCoordinate);
			}	
			if (filter != null) {
				baseElement.setAttribute("filter", filter);
			}	
		}				
		return baseElement;
	}		
	
	/**
	 * @see ISVGGraphicBase#getTransformation()
	 */
	public String getTransformation() {
		return transformation;
	}

	/**
	 * @see ISVGGraphicBase#getFill()
	 */

	public String getFill() {
		return fill;
	}
	
	/**
	 * @see ISVGGraphicBase#getStroke()
	 */

	public String getStroke() {
		return stroke;
	}
		
	/**
	 * @see ISVGGraphicBase#getXCoordinate()
	 */

	public String getXCoordinate() {
		return xCoordinate;
	}

	/**
	 * @see ISVGGraphicBase#getYCoordinate()
	 */

	public String getYCoordinate() {
		return yCoordinate;
	}
				
	/**
	 * @see ISVGGraphicBase#setTransformation()
	 */

	public void setTransformation(String tTransformation) {
		this.transformation = tTransformation;
	}
	
	/**
	 * @see ISVGGraphicBase#setFill()
	 */

	public void setFill(String fill) {
		if ((fill != null) && (!fill.trim().equals("")))
			this.fill = fill;
	}
		
	/**
	 * @see ISVGGraphicBase#setStroke()
	 */

	public void setStroke(String stroke) {
		if ((stroke != null) && (!stroke.trim().equals("")))
			this.stroke = stroke;
	}

	/**
	 * @see ISVGGraphicBase#setXCoordinate()
	 */

	public void setXCoordinate(String xCoordinate) {
		this.xCoordinate = xCoordinate;
	}

	/**
	 * @see ISVGGraphicBase#setYCoordinate()
	 */

	public void setYCoordinate(String yCoordinate) {
		this.yCoordinate = yCoordinate;
	}

	/**
	 * Returns the filter.
	 * @return String
	 */
	public String getFilter() {
		return filter;
	}

	/**
	 * Sets the filter.
	 * @param filter The filter to set
	 */
	public void setFilter(String filter) {
		this.filter = filter;
	}

}
