/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGGroup.java,v 1.3 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGGroup.java,v 1.3 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
/**
 * <code>SVGGroup</code> is an implementation class for Scalable Vector Graphics (SVG) 
 * "g" elements. 
 * 
 * $Revision: 1.3 $
 */
public class SVGGroup extends SVGContainerBase implements Serializable, ISVGGroup {	
	private Element implementation;
	private String transformation;
	private String fill;
	private String stroke;
	static final long serialVersionUID = 1454137114058834968L;
	
	Hashtable userEvents = null;
	
	/**
	 * Sole constructor.
	 */
	public SVGGroup() {
		super();
		setTagName("g");
	}	
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "g" element 
	 * 	
	 * @param Document the target SVG Document
	 * @param the array of objects which comprise the group
	 * @return Element the implementation.
	 * @throws NullPointerException ???
	 */
	public Element doImplementation(Document svgDocument) throws NullPointerException {	
		try {		
			implementation = super.doImplementation(svgDocument);

			if (transformation != null) {	
				implementation.setAttribute("transform", transformation);
			}
			
			if (fill != null) {
				implementation.setAttribute("fill", fill);
			}
			
			if (stroke != null) {
				implementation.setAttribute("stroke", stroke);
			}
			
			if (this.userEvents != null) {
				for (Enumeration e = this.userEvents.keys(); e.hasMoreElements(); ) {
					String event = (String) e.nextElement();
					implementation.setAttribute(event, (String) this.userEvents.get(event));
				}
			}
		} catch (DOMException e) {}
		
		return implementation;
	}		
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "g" element 
	 * 	
	 * @param Document the target SVG Document
	 * @param the array of objects which comprise the group
	 * @return Element the implementation.
	 * @throws NullPointerException ???
	 */
	public Element doImplementation(Document svgDocument, SVGBase [] children) throws NullPointerException {	
		setChildren(children);
		
		try {		
			implementation = super.doImplementation(svgDocument);
			
			if (this.userEvents != null) {
				for (Enumeration e = this.userEvents.keys(); e.hasMoreElements(); ) {
					String event = (String) e.nextElement();
					implementation.setAttribute(event, (String) this.userEvents.get(event));
				}
			}
		} catch (DOMException e) {}
		
		return implementation;
	}		
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "g" element 
	 * 	
	 * @param Document the target SVG Document
	 * @param the array of objects which comprise the group
	 * @param title the text for the title element
	 * @param description the text for the desc element
	 * @return Element the implementation.
	 * @throws NullPointerException ???
	 */
	public Element doImplementation(Document svgDocument, SVGBase [] children, String title, String description) throws NullPointerException {	
		setChildren(children);
		setTitle(title);
		setDesc(description);	
		
		try {		
			implementation = super.doImplementation(svgDocument);		

			if (this.userEvents != null) {
				for (Enumeration e = this.userEvents.keys(); e.hasMoreElements(); ) {
					String event = (String) e.nextElement();
					implementation.setAttribute(event, (String) this.userEvents.get(event));
				}
			}
		} catch (DOMException e) {}
		
		return implementation;
	}		
	
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}

	/**
	 * Adds a user event to this group element
	 * 
	 * @param event a String representing the type of event
	 * @param action a String representing the action to take
	 */
	public void addEvent(String event, String action) {
		if (this.userEvents == null) {
			this.userEvents = new Hashtable();
		}
		this.userEvents.put(event, action);
	}

	/**
	 * Gets transformation setting
	 * @return transformation
	 */
	public String getTransformation() {
		return transformation;
	}

	/**
	 * Sets transformation setting
	 * @param tTransformation transformation setting
	 */
	public void setTransformation(String tTransformation) {
		this.transformation = tTransformation;
	}
	/**
	 * @return
	 */
	public String getFill() {
		return fill;
	}

	/**
	 * @return
	 */
	public String getStroke() {
		return stroke;
	}

	/**
	 * @param string
	 */
	public void setFill(String string) {
		if ((string != null) && (!string.trim().equals("")))
			fill = string;
	}

	/**
	 * @param string
	 */
	public void setStroke(String string) {
		if ((string != null) && (!string.trim().equals("")))
			stroke = string;
	}

}
