/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGLine.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGLine.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * <code>SVGLine</code> is a implementation class for Scalable Vector Graphics (SVG) 
 * "Line" elements. 
 * 

 * $Revision: 1.2 $
 */

public class SVGLine extends SVGLineBase implements Serializable {
	Element implementation;
	static final long serialVersionUID = 1301672248687150005L;	
	/**
	 * Sole constructor.
	 */
	public SVGLine() {
		super();
		setTagName("line");
	}	
	
	/**
	 * Creates the Document Object Model (DOM) implementation of the SVG "line" element 
	 * @param Document the target SVG Document
	 * @param String x1
	 * @param String y1
	 * @param String x2
	 * @param String y2
	 * @param String strokeWidth
	 * @return
	 * @throws NullPointerException
	 */
	public Element doImplementation(Document svgDocument, String x1, String y1, String x2, String y2, String strokeWidth) throws NullPointerException {	
		setX1(x1);
		setY1(y1);
		setX2(x2);
		setY2(y2);
		if(strokeWidth != null){
			setStrokeWidth(strokeWidth);
		}
		
		try {
			implementation = super.doImplementation(svgDocument);		
		} catch (DOMException e) {}
		
		return implementation;
	}
		
	/**
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#getImplementation() 
	 */
	public Element getImplementation() {
		return implementation;
	}	
	

}
