/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGLineBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.generator;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGLineBase.java,v 1.1 2005/03/30 08:26:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.io.Serializable;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public abstract class SVGLineBase
	extends SVGGraphicBase
	implements ISVGLineBase, Serializable {
		private String x1;
		private String x2;
		private String y1;
		private String y2;
		private String strokeWidth;
		private String onmouseover;
		private String onmouseout;
	
		/**
		 * @see ISVGPolylineBase#doImplementation()
		 */
		public Element doImplementation(Document svgDocument) throws DOMException {
			Element LineElement;
		
			// nothing to do		
			if (x1 == null || x1 == null || y1 == null || y2 == null) {
				return null;
			}	
		
			// get our element
			LineElement = super.doImplementation(svgDocument);	
		
			// set any non-null attributes we know about
			if (LineElement != null) {					
				LineElement.setAttribute("x1", x1);	
				LineElement.setAttribute("y1", y1);	
				LineElement.setAttribute("x2", x2);	
				LineElement.setAttribute("y2", y2);	
				if(onmouseover != null){
					LineElement.setAttribute("onmouseover", onmouseover);
				}
				if(onmouseover != null){
					LineElement.setAttribute("onmouseout", onmouseout);
				}
				if (strokeWidth != null) {
					LineElement.setAttribute("stroke-width", strokeWidth);		
				}
			}
		
			return LineElement;
		}		
		
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGBase#getImplementation()
	 */
	public Element getImplementation() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGLineBase#getX1()
	 */
	public String getX1() {
		return x1;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGLineBase#getX2()
	 */
	public String getX2() {
		return x2;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGLineBase#getY1()
	 */
	public String getY1() {
		return y1;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGLineBase#getY2()
	 */
	public String getY2() {
		return y2;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGLineBase#setX1(java.lang.String)
	 */
	public void setX1(String string) {
		this.x1 = string;

	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGLineBase#setX2(java.lang.String)
	 */
	public void setX2(String string) {
		this.x2 = string;

	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGLineBase#setY1(java.lang.String)
	 */
	public void setY1(String string) {
		this.y1 = string;

	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGLineBase#setY2(java.lang.String)
	 */
	public void setY2(String string) {
		this.y2 = string;

	}

		/**
		 * @return
		 */
		public String getStrokeWidth() {
			return strokeWidth;
		}

		/**
		 * @param string
		 */
		public void setStrokeWidth(String string) {
			strokeWidth = string;
		}

		/**
		 * @return
		 */
		public String getOnmouseout() {
			return onmouseout;
		}

		/**
		 * @return
		 */
		public String getOnmouseover() {
			return onmouseover;
		}

		/**
		 * @param string
		 */
		public void setOnmouseout(String string) {
			onmouseout = string;
		}

		/**
		 * @param string
		 */
		public void setOnmouseover(String string) {
			onmouseover = string;
		}

}
